/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec;

import java.io.Serializable;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.scada.utils.lang.Immutable;
import org.eclipse.scada.utils.str.StringHelper;

@Immutable
public class UserInformation
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final UserInformation ANONYMOUS = new UserInformation(null, Collections.<String>emptySet());
    private final String name;
    private final Set<String> roles;

    public UserInformation(String name) {
        this.name = name;
        this.roles = Collections.emptySet();
    }

    public UserInformation(String name, Collection<String> roles) {
        this.name = name;
        this.roles = roles != null ? Collections.unmodifiableSet(new HashSet<String>(roles)) : Collections.emptySet();
    }

    public UserInformation(String name, String[] roles) {
        this(name, Arrays.asList(roles));
    }

    public static UserInformation fromPrincipal(Principal principal) {
        if (principal == null) {
            return ANONYMOUS;
        }
        return new UserInformation(principal.getName());
    }

    public boolean isAnonymous() {
        return this.name == null;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public boolean hasRole(String role) {
        return this.roles.contains(role);
    }

    public boolean hasAllRoles(String[] roles) {
        return this.roles.containsAll(Arrays.asList(roles));
    }

    public boolean hasAllRoles(Collection<String> roles) {
        return this.roles.containsAll(roles);
    }

    public boolean hasAnyRole(String[] roles) {
        String[] stringArray = roles;
        int n = roles.length;
        int n2 = 0;
        while (n2 < n) {
            String role = stringArray[n2];
            if (this.roles.contains(role)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean hasAnyRole(Collection<String> roles) {
        for (String role : roles) {
            if (!this.roles.contains(role)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.roles == null ? 0 : this.roles.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserInformation other = (UserInformation)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.roles == null ? other.roles != null : !this.roles.equals(other.roles));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[UserInformation - name=");
        if (this.name != null) {
            sb.append(this.name);
        } else {
            sb.append("<anonymous>");
        }
        sb.append(", roles=[");
        sb.append(StringHelper.join(this.roles, (String)", "));
        sb.append("]]");
        return sb.toString();
    }
}

