/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.protocol.ngp.codec.impl;

import java.util.List;
import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.core.data.CallbackResponse;
import org.eclipse.scada.core.data.ErrorInformation;
import org.eclipse.scada.core.data.Response;
import org.eclipse.scada.core.ngp.common.codec.osbp.BinaryContext;
import org.eclipse.scada.core.ngp.common.codec.osbp.BinaryMessageCodec;
import org.eclipse.scada.core.protocol.ngp.codec.Structures;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RespondCallbacks
implements BinaryMessageCodec {
    private static final Logger logger = LoggerFactory.getLogger(RespondCallbacks.class);
    public static final int MESSAGE_CODE = 258;

    public int getMessageCode() {
        return 258;
    }

    public Class<?> getMessageClass() {
        return org.eclipse.scada.core.data.message.RespondCallbacks.class;
    }

    public org.eclipse.scada.core.data.message.RespondCallbacks decodeMessage(BinaryContext _context, IoBuffer _data) throws Exception {
        int messageCode = _data.getInt();
        if (messageCode != 258) {
            throw new IllegalStateException(String.format("Expected messageCode %s but found %s", 258, messageCode));
        }
        int numberOfFields = _data.get();
        Response response = null;
        List<CallbackResponse> callbacks = null;
        ErrorInformation errorInformation = null;
        logger.trace("Decoding {} fields", (Object)((byte)numberOfFields));
        int i = 0;
        while (i < numberOfFields) {
            byte fieldNumber = _data.get();
            switch (fieldNumber) {
                case 1: {
                    response = Structures.decodeResponse(_context, _data, false);
                    break;
                }
                case 2: {
                    callbacks = Structures.decodeListCallbackResponse(_context, _data, true);
                    break;
                }
                case 3: {
                    errorInformation = Structures.decodeErrorInformation(_context, _data, true);
                    break;
                }
                default: {
                    logger.warn("Received unknown field number: {}", (Object)fieldNumber);
                }
            }
            ++i;
        }
        return new org.eclipse.scada.core.data.message.RespondCallbacks(response, callbacks, errorInformation);
    }

    public IoBuffer encodeMessage(BinaryContext context, Object objectMessage) throws Exception {
        org.eclipse.scada.core.data.message.RespondCallbacks value = (org.eclipse.scada.core.data.message.RespondCallbacks)objectMessage;
        IoBuffer data = IoBuffer.allocate((int)64);
        data.setAutoExpand(true);
        data.putInt(258);
        data.put((byte)3);
        Structures.encodeResponse(context, data, (byte)1, value.getResponse());
        Structures.encodeCollectionCallbackResponse(context, data, (byte)2, value.getCallbacks());
        Structures.encodeErrorInformation(context, data, (byte)3, value.getErrorInformation());
        data.flip();
        return data;
    }
}

