/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.client;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.scada.core.client.ConnectionState;
import org.eclipse.scada.core.client.ConnectionStateListener;
import org.eclipse.scada.da.client.Connection;
import org.eclipse.scada.da.client.ItemManager;
import org.eclipse.scada.da.client.ItemSyncController;
import org.eclipse.scada.da.client.ItemUpdateListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemManagerImpl
implements ConnectionStateListener,
ItemManager {
    private static final Logger logger = LoggerFactory.getLogger(ItemManagerImpl.class);
    protected Connection connection;
    private final Map<String, ItemSyncController> itemListeners = new HashMap<String, ItemSyncController>();
    private boolean connected;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemManagerImpl(Connection connection) {
        this.connection = connection;
        ItemManagerImpl itemManagerImpl = this;
        synchronized (itemManagerImpl) {
            this.connection.addConnectionStateListener(this);
            this.connected = this.connection.getState() == ConnectionState.BOUND;
        }
    }

    public Executor getExecutor() {
        return this.connection.getExecutor();
    }

    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public synchronized void addItemUpdateListener(String itemName, ItemUpdateListener listener) {
        logger.debug("Adding item update listener - itemId: {}, listener: {}", (Object)itemName, (Object)listener);
        ItemSyncController controller = this.itemListeners.get(itemName);
        if (controller == null) {
            controller = new ItemSyncController(this.connection, this, itemName);
            this.itemListeners.put(itemName, controller);
        }
        controller.add(listener);
    }

    @Override
    public synchronized void removeItemUpdateListener(String itemName, ItemUpdateListener listener) {
        logger.debug("Removing item update listener - itemId: {}, listener: {}", (Object)itemName, (Object)listener);
        if (itemName == null) {
            return;
        }
        ItemSyncController controller = this.itemListeners.get(itemName);
        if (controller != null) {
            controller.remove(listener);
        }
    }

    protected synchronized void resyncAllItems() {
        logger.debug("Syncing all items ({})", (Object)this.itemListeners.size());
        for (Map.Entry<String, ItemSyncController> entry : this.itemListeners.entrySet()) {
            entry.getValue().sync(true);
        }
        logger.debug("re-sync complete");
    }

    protected synchronized void disconnectAllItems() {
        logger.debug("Disconnecting all items");
        for (Map.Entry<String, ItemSyncController> entry : this.itemListeners.entrySet()) {
            entry.getValue().disconnect();
        }
        logger.debug("Disconnecting all items: complete");
    }

    public synchronized void stateChange(org.eclipse.scada.core.client.Connection connection, ConnectionState state, Throwable error) {
        switch (state) {
            case BOUND: {
                if (this.connected) break;
                this.resyncAllItems();
                this.connected = true;
                break;
            }
            default: {
                if (!this.connected) break;
                this.disconnectAllItems();
                this.connected = false;
            }
        }
    }
}

