/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.ngp.common.mc;

import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.core.write.WriteRequestWrapper;
import org.eclipse.scada.protocol.ngp.common.mc.frame.Frame;
import org.eclipse.scada.protocol.ngp.common.mc.message.AcceptMessage;
import org.eclipse.scada.protocol.ngp.common.mc.message.CloseMessage;
import org.eclipse.scada.protocol.ngp.common.mc.message.DataMessage;
import org.eclipse.scada.protocol.ngp.common.mc.message.HelloMessage;
import org.eclipse.scada.protocol.ngp.common.mc.message.StartMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageChannelCodecFilter
extends IoFilterAdapter {
    private static final Logger logger = LoggerFactory.getLogger(MessageChannelCodecFilter.class);

    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        logger.trace("messageReceived: {}", message);
        if (!(message instanceof Frame)) {
            throw new IllegalStateException("Can only handle Frame messages");
        }
        Frame frame = (Frame)message;
        switch (frame.getType()) {
            case MESSAGE: {
                nextFilter.messageReceived(session, (Object)new DataMessage(frame.getData()));
                break;
            }
            case HELLO: {
                nextFilter.messageReceived(session, (Object)this.decodeHelloFrame(session, frame.getData()));
                break;
            }
            case ACCEPT: {
                nextFilter.messageReceived(session, (Object)this.decodeAcceptFrame(session, frame.getData()));
                break;
            }
            case CLOSE: {
                nextFilter.messageReceived(session, (Object)this.decodeCloseFrame(session, frame.getData()));
                break;
            }
            case START: {
                nextFilter.messageReceived(session, (Object)new StartMessage());
                break;
            }
            case PING: {
                break;
            }
        }
    }

    private CloseMessage decodeCloseFrame(IoSession session, IoBuffer data) throws CharacterCodingException {
        return new CloseMessage(data.getString(this.getCharsetDecoder(session)), data.getInt());
    }

    private AcceptMessage decodeAcceptFrame(IoSession session, IoBuffer data) throws CharacterCodingException {
        return new AcceptMessage(this.decodeProperties(session, data));
    }

    private HelloMessage decodeHelloFrame(IoSession session, IoBuffer data) throws CharacterCodingException {
        return new HelloMessage(this.decodeProperties(session, data));
    }

    private Map<String, String> decodeProperties(IoSession session, IoBuffer data) throws CharacterCodingException {
        int count = data.getInt();
        HashMap<String, String> result = new HashMap<String, String>(count);
        CharsetDecoder decoder = this.getCharsetDecoder(session);
        int i = 0;
        while (i < count) {
            String key = data.getString(decoder);
            String value = data.getString(decoder);
            result.put(key, value);
            ++i;
        }
        return result;
    }

    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        if (writeRequest.getMessage() instanceof CloseMessage) {
            nextFilter.filterWrite(session, (WriteRequest)new WriteRequestWrapperExtension(writeRequest, this.encodeCloseMessage(session, (CloseMessage)writeRequest.getMessage())));
        } else if (writeRequest.getMessage() instanceof HelloMessage) {
            nextFilter.filterWrite(session, (WriteRequest)new WriteRequestWrapperExtension(writeRequest, this.encodeHelloMessage(session, (HelloMessage)writeRequest.getMessage())));
        } else if (writeRequest.getMessage() instanceof AcceptMessage) {
            nextFilter.filterWrite(session, (WriteRequest)new WriteRequestWrapperExtension(writeRequest, this.encodeAcceptMessage(session, (AcceptMessage)writeRequest.getMessage())));
        } else if (writeRequest.getMessage() instanceof StartMessage) {
            nextFilter.filterWrite(session, (WriteRequest)new WriteRequestWrapperExtension(writeRequest, this.encodeStartMessage(session)));
        } else if (writeRequest.getMessage() instanceof DataMessage) {
            nextFilter.filterWrite(session, (WriteRequest)new WriteRequestWrapperExtension(writeRequest, this.makeMessageFrame((DataMessage)writeRequest.getMessage())));
        } else {
            throw new IllegalStateException(String.format("Unable to process message of type: %s", writeRequest.getMessage().getClass()));
        }
    }

    private Frame makeMessageFrame(DataMessage message) {
        return new Frame(Frame.FrameType.MESSAGE, message.getData());
    }

    private Frame encodeStartMessage(IoSession session) throws CharacterCodingException {
        return new Frame(Frame.FrameType.START);
    }

    private Frame encodeAcceptMessage(IoSession session, AcceptMessage message) throws CharacterCodingException {
        return new Frame(Frame.FrameType.ACCEPT, this.encodeProperties(session, message.getProperties()));
    }

    private Frame encodeHelloMessage(IoSession session, HelloMessage message) throws CharacterCodingException {
        return new Frame(Frame.FrameType.HELLO, this.encodeProperties(session, message.getProperties()));
    }

    private IoBuffer encodeProperties(IoSession session, Map<String, String> properties) throws CharacterCodingException {
        IoBuffer data = IoBuffer.allocate((int)0);
        data.setAutoExpand(true);
        data.putInt(properties.size());
        CharsetEncoder encoder = this.getCharsetEncoder(session);
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            data.putString((CharSequence)key, encoder);
            data.put((byte)0);
            data.putString((CharSequence)value, encoder);
            data.put((byte)0);
        }
        data.flip();
        return data;
    }

    private Frame encodeCloseMessage(IoSession session, CloseMessage message) throws CharacterCodingException {
        IoBuffer data = IoBuffer.allocate((int)0);
        data.setAutoExpand(true);
        data.putString((CharSequence)message.getMessage(), this.getCharsetEncoder(session));
        data.put((byte)0);
        data.putInt(message.getCode());
        data.flip();
        return new Frame(Frame.FrameType.CLOSE, data);
    }

    private CharsetEncoder getCharsetEncoder(IoSession session) {
        if (session.containsAttribute((Object)"charsetEncoder")) {
            return (CharsetEncoder)session.getAttribute((Object)"charsetEncoder");
        }
        CharsetEncoder encoder = Charset.forName("UTF-8").newEncoder();
        session.setAttribute((Object)"charsetEncoder", (Object)encoder);
        return encoder;
    }

    private CharsetDecoder getCharsetDecoder(IoSession session) {
        if (session.containsAttribute((Object)"charsetDecoder")) {
            return (CharsetDecoder)session.getAttribute((Object)"charsetDecoder");
        }
        CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();
        session.setAttribute((Object)"charsetDecoder", (Object)decoder);
        return decoder;
    }

    private final class WriteRequestWrapperExtension
    extends WriteRequestWrapper {
        private final Object message;

        private WriteRequestWrapperExtension(WriteRequest parentRequest, Object message) {
            super(parentRequest);
            this.message = message;
        }

        public Object getMessage() {
            return this.message;
        }
    }
}

