/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.details.swt.impl.visibility;

import java.util.Map;
import java.util.regex.Pattern;
import javax.script.ScriptContext;
import javax.script.ScriptEngineManager;
import org.eclipse.scada.utils.str.StringReplacer;
import org.eclipse.scada.vi.details.model.Invisible;
import org.eclipse.scada.vi.details.model.PermissionVisibility;
import org.eclipse.scada.vi.details.model.ScriptVisibility;
import org.eclipse.scada.vi.details.model.TestVisibility;
import org.eclipse.scada.vi.details.model.Visibility;
import org.eclipse.scada.vi.details.swt.Constants;
import org.eclipse.scada.vi.details.swt.impl.visibility.PermissionVisibilityProviderImpl;
import org.eclipse.scada.vi.details.swt.impl.visibility.ScriptVisibilityProviderImpl;
import org.eclipse.scada.vi.details.swt.impl.visibility.StaticVisibileProvider;
import org.eclipse.scada.vi.details.swt.impl.visibility.TestVisibilityImpl;
import org.eclipse.scada.vi.details.swt.impl.visibility.VisibilityProvider;

public class VisibilityProviderFactory {
    private final ScriptEngineManager scriptEngineManager;
    private final ScriptContext scriptContext;
    private final Map<String, String> properties;

    public VisibilityProviderFactory(ScriptEngineManager scriptEngineManager, ScriptContext scriptContext, Map<String, String> properties) {
        this.scriptEngineManager = scriptEngineManager;
        this.scriptContext = scriptContext;
        this.properties = properties;
    }

    public VisibilityProvider createProvider(Visibility object) {
        if (object == null) {
            return StaticVisibileProvider.VISIBLE_INSTANCE;
        }
        if (object instanceof PermissionVisibility) {
            return new PermissionVisibilityProviderImpl(this.resolveProperties(((PermissionVisibility)object).getRequiredPermission()));
        }
        if (object instanceof ScriptVisibility) {
            return new ScriptVisibilityProviderImpl(this.scriptEngineManager, this.scriptContext, ((ScriptVisibility)object).getScriptLanguage(), ((ScriptVisibility)object).getScript());
        }
        if (object instanceof Invisible) {
            return StaticVisibileProvider.INVISIBLE_INSTANCE;
        }
        if (object instanceof TestVisibility) {
            return new TestVisibilityImpl(((TestVisibility)object).getId());
        }
        return StaticVisibileProvider.INVISIBLE_INSTANCE;
    }

    private String resolveProperties(String input) {
        if (input == null) {
            return null;
        }
        return StringReplacer.replace((String)input, (StringReplacer.ReplaceSource)StringReplacer.newSource(this.properties), (Pattern)Constants.DEFAULT_PATTERN);
    }
}

