/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.details.swt.widgets.control;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.ui.connection.data.Item;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.sec.ui.DisplayCallbackHandler;
import org.eclipse.scada.vi.data.DataValue;
import org.eclipse.scada.vi.data.RegistrationManager;
import org.eclipse.scada.vi.details.swt.Activator;
import org.eclipse.scada.vi.details.swt.dialog.LockMessageDialog;
import org.eclipse.scada.vi.details.swt.widgets.DataItemToolTip;
import org.eclipse.scada.vi.details.swt.widgets.Messages;
import org.eclipse.scada.vi.details.swt.widgets.control.ControlImage;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockControlImage
extends Composite
implements RegistrationManager.Listener {
    private static final Logger logger = LoggerFactory.getLogger(BlockControlImage.class);
    private static final String ATTR_BLOCK_ACTIVE = "org.eclipse.scada.da.master.common.block.active";
    private static final String ATTR_BLOCK_NOTE = "org.eclipse.scada.da.master.common.block.note";
    private static final String ATTR_BLOCK_USER = "org.eclipse.scada.da.master.common.block.user";
    private static final String ATTR_BLOCK_TIMESTAMP = "org.eclipse.scada.da.master.common.block.timestamp";
    private final Label icon;
    private final RegistrationManager registrationManager;
    private Item item;
    private final ControlImage controlImage;
    private final StyledString.Styler boldStyler;
    private DataItemToolTip tooltip;
    private final Font boldFont;

    public BlockControlImage(ControlImage controlImage, int style, RegistrationManager registrationManager) {
        super(controlImage.getClientSpace(), style);
        this.controlImage = controlImage;
        this.registrationManager = registrationManager;
        this.setLayout((Layout)new FillLayout());
        this.icon = new Label((Composite)this, 0);
        this.icon.setImage(this.getEmptyImage());
        this.icon.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                BlockControlImage.this.toggleBlock();
            }
        });
        this.registrationManager.addListener((RegistrationManager.Listener)this);
        LocalResourceManager resources = new LocalResourceManager(JFaceResources.getResources(), (Control)this.icon);
        this.boldFont = resources.createFont(JFaceResources.getDefaultFontDescriptor().withStyle(1));
        this.boldStyler = new StyledString.Styler(){

            public void applyStyles(TextStyle textStyle) {
                textStyle.font = BlockControlImage.this.boldFont;
            }
        };
    }

    public void setBlockItem(Item item) {
        this.item = item;
        this.tooltip = new DataItemToolTip((Control)this.icon, item);
        this.tooltip.setShift(new Point(5, 5));
        this.tooltip.activate();
        this.updateState();
    }

    private Image getEmptyImage() {
        return Activator.getDefault().getImageRegistry().get("empty");
    }

    protected void handleDispose() {
        this.registrationManager.removeListener((RegistrationManager.Listener)this);
    }

    public void triggerDataUpdate() {
        final Display display = this.getDisplay();
        if (display.isDisposed()) {
            return;
        }
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (display.isDisposed()) {
                    return;
                }
                BlockControlImage.this.updateState();
            }
        });
    }

    private void updateState() {
        if (this.icon.isDisposed()) {
            return;
        }
        DataItemValue value = this.getBlockItemValue();
        if (value == null) {
            this.icon.setImage(this.getEmptyImage());
            this.tooltip.deactivate();
            return;
        }
        if (this.isActive(value)) {
            this.icon.setImage(Activator.getDefault().getImageRegistry().get("blocked"));
            this.tooltip.setText(this.getStyledString(this.getActiveBlockAttribute(value, ATTR_BLOCK_NOTE), this.getActiveBlockAttribute(value, ATTR_BLOCK_USER), value.getAsTimestamp(ATTR_BLOCK_TIMESTAMP)));
            this.tooltip.activate();
        } else {
            this.icon.setImage(Activator.getDefault().getImageRegistry().get("empty"));
            this.tooltip.deactivate();
        }
        this.controlImage.layout();
    }

    private DataItemValue getBlockItemValue() {
        return this.findValue(this.registrationManager.getData(), this.item);
    }

    private boolean isActive(DataItemValue value) {
        return value.isAttribute(ATTR_BLOCK_ACTIVE, false);
    }

    private DataItemValue findValue(Map<String, DataValue> data, Item item) {
        for (DataValue value : data.values()) {
            if (!value.getItem().equals((Object)item)) continue;
            return value.getValue();
        }
        return null;
    }

    protected void toggleBlock() {
        DataItemValue value = this.getBlockItemValue();
        HashMap<String, Variant> attributes = new HashMap<String, Variant>();
        if (!this.isActive(value)) {
            String reason = this.getBlockReason(value);
            if (reason == null) {
                return;
            }
            if (reason.isEmpty()) {
                attributes.put(ATTR_BLOCK_NOTE, Variant.valueOf((Object)Messages.BlockControllerImage_String_BlockNote_None));
            } else {
                attributes.put(ATTR_BLOCK_NOTE, Variant.valueOf((Object)reason));
            }
        } else {
            String blockNote = this.getActiveBlockAttribute(value, ATTR_BLOCK_NOTE);
            if (blockNote == null || blockNote.isEmpty()) {
                blockNote = Messages.BlockControllerImage_String_BlockNote_None;
            }
            if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.BlockControllerImage_ConfirmDialog_Title, (String)String.format(Messages.BlockControllerImage_ConfirmDialog_Message_Format, blockNote))) {
                return;
            }
        }
        attributes.put(ATTR_BLOCK_ACTIVE, Variant.valueOf((!this.isActive(value) ? 1 : 0) != 0));
        try {
            DisplayCallbackHandler handler = new DisplayCallbackHandler(this.getShell(), "Confirmation", "Confirm block operation");
            this.registrationManager.startWriteAttributes(this.item.getConnectionString(), this.item.getId(), attributes, (CallbackHandler)handler);
        }
        catch (InterruptedException e) {
            logger.warn("Failed to write", (Throwable)e);
        }
    }

    private String getActiveBlockAttribute(DataItemValue value, String attribute) {
        if (value == null || value.getAttributes() == null) {
            return null;
        }
        Variant v = (Variant)value.getAttributes().get(attribute);
        if (v == null) {
            return null;
        }
        return v.asString(null);
    }

    private String getBlockReason(DataItemValue value) {
        return new LockMessageDialog(this.getShell(), this.getActiveBlockAttribute(value, ATTR_BLOCK_NOTE)).openDialog();
    }

    protected StyledString getStyledString(String note, String user, Calendar timestamp) {
        StyledString string = new StyledString();
        if (timestamp != null) {
            string.append(Messages.BlockControllerImage_String_Timestamp, this.boldStyler);
            string.append(String.valueOf(timestamp.getTime().toString()) + "\n\n");
        }
        if (user != null) {
            string.append(Messages.BlockControllerImage_String_BlockedBy, this.boldStyler);
            if (user.equals("")) {
                string.append(Messages.BlockControllerImage_String_Unknown);
            } else {
                string.append(user);
            }
        }
        if (note != null) {
            if (string.length() > 0) {
                string.append("\n");
            }
            string.append(Messages.BlockControllerImage_String_Reason, this.boldStyler);
            if (note.equals("")) {
                string.append(Messages.BlockControllerImage_String_None);
            } else {
                string.append(note);
            }
        }
        return string;
    }
}

