/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.connection.provider.internal;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.OperationException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.client.ConnectionState;
import org.eclipse.scada.core.client.ConnectionStateListener;
import org.eclipse.scada.core.client.NoConnectionException;
import org.eclipse.scada.core.client.PrivilegeListener;
import org.eclipse.scada.core.data.OperationParameters;
import org.eclipse.scada.da.client.BrowseOperationCallback;
import org.eclipse.scada.da.client.Connection;
import org.eclipse.scada.da.client.FolderListener;
import org.eclipse.scada.da.client.ItemUpdateListener;
import org.eclipse.scada.da.client.WriteAttributeOperationCallback;
import org.eclipse.scada.da.client.WriteOperationCallback;
import org.eclipse.scada.da.core.Location;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.core.WriteResult;
import org.eclipse.scada.sec.callback.CallbackFactory;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.eclipse.scada.utils.stats.StatisticEntry;
import org.eclipse.scada.utils.stats.StatisticsImpl;
import org.eclipse.scada.utils.stats.StatisticsProvider;

public abstract class LazyConnectionWrapper
implements Connection,
StatisticsProvider {
    private static final Object STATS_REQUEST_OPEN = new Object();
    private static final Object STATS_ITEM_SUBSCRIPTIONS = new Object();
    private static final Object STATS_LINGERING_CLOSE = new Object();
    private final Set<String> subscribedItems = new HashSet<String>();
    private final Connection connection;
    private final StatisticsImpl statistics = new StatisticsImpl();
    private final Integer lingeringTimeout;
    private long disconnectTimestamp;
    private final Runnable performConnectionCheck = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LazyConnectionWrapper lazyConnectionWrapper = LazyConnectionWrapper.this;
            synchronized (lazyConnectionWrapper) {
                LazyConnectionWrapper.this.checkConnection();
            }
        }
    };

    public LazyConnectionWrapper(Connection connection, Integer lingeringTimeout) {
        this.connection = connection;
        this.lingeringTimeout = lingeringTimeout;
        this.statistics.setLabel(STATS_REQUEST_OPEN, "Requesting connection");
        this.statistics.setLabel(STATS_ITEM_SUBSCRIPTIONS, "Item subscriptions");
        this.statistics.setLabel(STATS_LINGERING_CLOSE, "Lingering close active");
    }

    public void setCallbackFactory(CallbackFactory callbackFactory) {
        this.connection.setCallbackFactory(callbackFactory);
    }

    public void connect() {
        this.connection.connect();
    }

    public void connect(CallbackHandler callbackHandler) {
        this.connection.connect(callbackHandler);
    }

    public void disconnect() {
        this.connection.disconnect();
    }

    public void dispose() {
        this.connection.dispose();
    }

    public void addConnectionStateListener(ConnectionStateListener connectionStateListener) {
        this.connection.addConnectionStateListener(connectionStateListener);
    }

    public void removeConnectionStateListener(ConnectionStateListener connectionStateListener) {
        this.connection.removeConnectionStateListener(connectionStateListener);
    }

    public ConnectionState getState() {
        return this.connection.getState();
    }

    public ConnectionInformation getConnectionInformation() {
        return this.connection.getConnectionInformation();
    }

    public Map<String, String> getSessionProperties() {
        return this.connection.getSessionProperties();
    }

    public void addPrivilegeListener(PrivilegeListener listener) {
        this.connection.addPrivilegeListener(listener);
    }

    public void removePrivilegeListener(PrivilegeListener listener) {
        this.connection.removePrivilegeListener(listener);
    }

    public Set<String> getPrivileges() {
        return this.connection.getPrivileges();
    }

    public void browse(Location location, BrowseOperationCallback callback) {
        this.connection.browse(location, callback);
    }

    public void write(String itemId, Variant value, OperationParameters operationParameters, WriteOperationCallback callback) {
        this.connection.write(itemId, value, operationParameters, callback);
    }

    public void writeAttributes(String itemId, Map<String, Variant> attributes, OperationParameters operationParameters, WriteAttributeOperationCallback callback) {
        this.connection.writeAttributes(itemId, attributes, operationParameters, callback);
    }

    public NotifyFuture<WriteResult> startWrite(String itemId, Variant value, OperationParameters operationParameters, CallbackHandler callbackHandler) {
        return this.connection.startWrite(itemId, value, operationParameters, callbackHandler);
    }

    public NotifyFuture<WriteAttributeResults> startWriteAttributes(String itemId, Map<String, Variant> attributes, OperationParameters operationParameters, CallbackHandler callbackHandler) {
        return this.connection.startWriteAttributes(itemId, attributes, operationParameters, callbackHandler);
    }

    public void subscribeFolder(Location location) throws NoConnectionException, OperationException {
        this.connection.subscribeFolder(location);
    }

    public void unsubscribeFolder(Location location) throws NoConnectionException, OperationException {
        this.connection.unsubscribeFolder(location);
    }

    public FolderListener setFolderListener(Location location, FolderListener listener) {
        return this.connection.setFolderListener(location, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeItem(String itemId) throws NoConnectionException, OperationException {
        LazyConnectionWrapper lazyConnectionWrapper = this;
        synchronized (lazyConnectionWrapper) {
            if (this.subscribedItems.add(itemId)) {
                this.statistics.setCurrentValue(STATS_ITEM_SUBSCRIPTIONS, (double)this.subscribedItems.size());
                this.checkConnection();
            }
        }
        this.connection.subscribeItem(itemId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeItem(String itemId) throws NoConnectionException, OperationException {
        LazyConnectionWrapper lazyConnectionWrapper = this;
        synchronized (lazyConnectionWrapper) {
            if (this.subscribedItems.remove(itemId)) {
                this.statistics.setCurrentValue(STATS_ITEM_SUBSCRIPTIONS, (double)this.subscribedItems.size());
                this.checkConnection();
            }
        }
        this.connection.unsubscribeItem(itemId);
    }

    private void checkConnection() {
        if (this.subscribedItems.isEmpty()) {
            if (this.lingeringTimeout == null) {
                this.statistics.setCurrentValue(STATS_REQUEST_OPEN, 0.0);
                this.performDisconnect();
            } else if (this.disconnectTimestamp != 0L && this.disconnectTimestamp + (long)this.lingeringTimeout.intValue() <= System.currentTimeMillis()) {
                this.statistics.setCurrentValue(STATS_REQUEST_OPEN, 0.0);
                this.statistics.setCurrentValue(STATS_LINGERING_CLOSE, 0.0);
                this.disconnectTimestamp = 0L;
                this.performDisconnect();
            } else {
                this.disconnectTimestamp = System.currentTimeMillis();
                this.statistics.setCurrentValue(STATS_LINGERING_CLOSE, 1.0);
                this.connection.getExecutor().schedule(this.performConnectionCheck, (long)this.lingeringTimeout.intValue(), TimeUnit.MILLISECONDS);
            }
        } else {
            this.statistics.setCurrentValue(STATS_REQUEST_OPEN, 1.0);
            this.performConnect();
            if (this.lingeringTimeout != null) {
                this.disconnectTimestamp = 0L;
                this.statistics.setCurrentValue(STATS_LINGERING_CLOSE, 0.0);
            }
        }
    }

    protected abstract void performConnect();

    protected abstract void performDisconnect();

    public ItemUpdateListener setItemUpdateListener(String itemId, ItemUpdateListener listener) {
        return this.connection.setItemUpdateListener(itemId, listener);
    }

    public ScheduledExecutorService getExecutor() {
        return this.connection.getExecutor();
    }

    public Collection<StatisticEntry> getStatistics() {
        LinkedList<StatisticEntry> result = new LinkedList<StatisticEntry>();
        if (this.connection instanceof StatisticsProvider) {
            result.addAll(((StatisticsProvider)this.connection).getStatistics());
        }
        result.addAll(this.statistics.getEntries());
        return result;
    }
}

