/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.chart;

import java.util.NavigableSet;
import java.util.TreeSet;
import org.eclipse.scada.chart.DataEntry;
import org.eclipse.scada.chart.SeriesViewData;
import org.eclipse.scada.chart.WritableSeries;

public class WritableSeriesData
implements SeriesViewData {
    private double minValue = Double.POSITIVE_INFINITY;
    private double maxValue = Double.NEGATIVE_INFINITY;
    private long minTimestamp = Long.MAX_VALUE;
    private long maxTimestamp = Long.MIN_VALUE;
    private final TreeSet<DataEntry> entries = new TreeSet();
    private final WritableSeries writableSeries;

    public WritableSeriesData() {
        this(null);
    }

    public WritableSeriesData(WritableSeries writableSeries) {
        this.writableSeries = writableSeries;
    }

    public boolean add(DataEntry entry) {
        this.minValue = WritableSeriesData.minValue(this.minValue, entry.getValue());
        this.maxValue = WritableSeriesData.maxValue(this.maxValue, entry.getValue());
        this.minTimestamp = Math.min(this.minTimestamp, entry.getTimestamp());
        this.maxTimestamp = Math.max(this.maxTimestamp, entry.getTimestamp());
        boolean result = this.entries.add(entry);
        if (this.writableSeries != null) {
            this.writableSeries.fireUpdateListener(entry.getTimestamp(), entry.getTimestamp());
        }
        return result;
    }

    public void addAsLast(DataEntry entry) {
        this.entries.tailSet(entry, true).clear();
        this.add(entry);
    }

    public boolean remove(DataEntry entry) {
        boolean result = this.entries.remove(entry);
        this.writableSeries.fireUpdateListener(entry.getTimestamp(), entry.getTimestamp());
        return result;
    }

    private static double minValue(double a, Double b) {
        if (b == null) {
            return a;
        }
        return Math.min(a, b);
    }

    private static double maxValue(double a, Double b) {
        if (b == null) {
            return a;
        }
        return Math.max(a, b);
    }

    @Override
    public long getMaxTimestamp() {
        return this.maxTimestamp;
    }

    @Override
    public long getMinTimestamp() {
        return this.minTimestamp;
    }

    @Override
    public double getMaxValue() {
        return this.maxValue;
    }

    @Override
    public double getMinValue() {
        return this.minValue;
    }

    @Override
    public NavigableSet<DataEntry> getEntries() {
        return this.entries;
    }
}

