/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.net;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.scada.core.net.MessageHelper;
import org.eclipse.scada.hd.data.HistoricalItemInformation;
import org.eclipse.scada.net.base.data.ListValue;
import org.eclipse.scada.net.base.data.MapValue;
import org.eclipse.scada.net.base.data.Message;
import org.eclipse.scada.net.base.data.StringValue;
import org.eclipse.scada.net.base.data.Value;
import org.eclipse.scada.net.base.data.VoidValue;

public class ItemListHelper {
    public static final String FIELD_ADDED = "added";
    public static final String FIELD_REMOVED = "removed";
    public static final String FIELD_FULL = "full";

    public static Set<HistoricalItemInformation> fromValue(Value baseValue) {
        if (!(baseValue instanceof ListValue)) {
            return null;
        }
        HashSet<HistoricalItemInformation> result = new HashSet<HistoricalItemInformation>();
        ListValue value = (ListValue)baseValue;
        for (Value entryValue : value.getValues()) {
            HistoricalItemInformation entry = ItemListHelper.fromValueEntry(entryValue);
            if (entry == null) continue;
            result.add(entry);
        }
        return result;
    }

    private static HistoricalItemInformation fromValueEntry(Value entryValue) {
        Value attributes;
        String id;
        block5: {
            if (!(entryValue instanceof MapValue)) {
                return null;
            }
            MapValue value = (MapValue)entryValue;
            id = ((StringValue)value.get("id")).getValue();
            attributes = value.get("attributes");
            if (attributes instanceof MapValue) break block5;
            return null;
        }
        try {
            return new HistoricalItemInformation(id, MessageHelper.mapToAttributes((MapValue)((MapValue)attributes)));
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public static Value toValueAdded(Collection<HistoricalItemInformation> added) {
        ListValue result = new ListValue();
        if (added != null) {
            for (HistoricalItemInformation entry : added) {
                result.add(ItemListHelper.toValue(entry));
            }
        }
        return result;
    }

    private static Value toValue(HistoricalItemInformation entry) {
        MapValue value = new MapValue();
        value.put("id", (Value)new StringValue(entry.getItemId()));
        value.put("attributes", (Value)MessageHelper.attributesToMap((Map)entry.getAttributes()));
        return value;
    }

    public static Value toValueRemoved(Collection<String> removed) {
        if (removed == null) {
            return VoidValue.INSTANCE;
        }
        ListValue result = new ListValue();
        for (String entry : removed) {
            result.add((Value)new StringValue(entry));
        }
        return result;
    }

    public static Set<String> fromValueRemoved(Value value) {
        if (!(value instanceof ListValue)) {
            return null;
        }
        HashSet<String> removed = new HashSet<String>();
        for (Value entryValue : ((ListValue)value).getValues()) {
            if (!(entryValue instanceof StringValue)) continue;
            removed.add(((StringValue)entryValue).getValue());
        }
        return removed;
    }

    public static Message createRequestList(boolean flag) {
        Message message = new Message(flag ? 262161 : 262162);
        return message;
    }
}

