/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.chart.swt;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.chart.swt.ChartMouseListener;
import org.eclipse.scada.chart.swt.ChartMouseMoveListener;
import org.eclipse.scada.chart.swt.ChartRenderer;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class ChartAreaRenderer
extends ChartRenderer {
    private final Composite control;
    private final Map<ChartMouseListener, MouseListener> mouseListenerMap = new HashMap<ChartMouseListener, MouseListener>();
    private final Map<ChartMouseMoveListener, MouseMoveListener> mouseMoveListenerMap = new HashMap<ChartMouseMoveListener, MouseMoveListener>();

    public ChartAreaRenderer(Composite control) {
        this.control = control;
    }

    @Override
    public Display getDisplay() {
        return this.control.getDisplay();
    }

    @Override
    public void redraw() {
        this.control.redraw();
    }

    @Override
    public void setFocus() {
        this.control.setFocus();
    }

    @Override
    public Rectangle getClientArea() {
        return this.control.getClientArea();
    }

    protected ChartMouseListener.MouseState convertState(MouseEvent e) {
        ChartMouseListener.MouseState state = new ChartMouseListener.MouseState();
        state.button = e.button;
        state.x = e.x;
        state.y = e.y;
        state.state = e.stateMask;
        return state;
    }

    @Override
    public void addMouseListener(final ChartMouseListener listener) {
        this.removeMouseListener(listener);
        MouseListener proxyListener = new MouseListener(){

            public void mouseUp(MouseEvent e) {
                listener.onMouseUp(ChartAreaRenderer.this.convertState(e));
            }

            public void mouseDown(MouseEvent e) {
                listener.onMouseDown(ChartAreaRenderer.this.convertState(e));
            }

            public void mouseDoubleClick(MouseEvent e) {
                listener.onMouseDoubleClick(ChartAreaRenderer.this.convertState(e));
            }
        };
        this.mouseListenerMap.put(listener, proxyListener);
        this.control.addMouseListener(proxyListener);
    }

    @Override
    public void removeMouseListener(ChartMouseListener listener) {
        MouseListener proxyListener = this.mouseListenerMap.remove(listener);
        if (proxyListener != null) {
            this.control.removeMouseListener(proxyListener);
        }
    }

    @Override
    public void addMouseMoveListener(final ChartMouseMoveListener listener) {
        this.removeMouseMoveListener(listener);
        MouseMoveListener proxyListener = new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                listener.onMouseMove(ChartAreaRenderer.this.convertState(e));
            }
        };
        MouseMoveListener oldListener = this.mouseMoveListenerMap.put(listener, proxyListener);
        if (oldListener != null) {
            this.control.removeMouseMoveListener(oldListener);
        }
        this.control.addMouseMoveListener(proxyListener);
    }

    @Override
    public void removeMouseMoveListener(ChartMouseMoveListener listener) {
        MouseMoveListener proxyListener = this.mouseMoveListenerMap.remove(listener);
        if (proxyListener != null && !this.control.isDisposed()) {
            this.control.removeMouseMoveListener(proxyListener);
        }
    }

    @Override
    public void addMouseWheelListener(MouseWheelListener listener) {
        this.control.addMouseWheelListener(listener);
    }

    @Override
    public void removeMouseWheelListener(MouseWheelListener listener) {
        if (!this.control.isDisposed()) {
            this.control.removeMouseWheelListener(listener);
        }
    }

    @Override
    public DropTarget createDropTarget(Transfer[] transfers, DropTargetAdapter createDropTarget) {
        this.checkWidget();
        DropTarget target = new DropTarget((Control)this.control, 21);
        target.setTransfer(transfers);
        target.addDropListener((DropTargetListener)createDropTarget);
        return target;
    }
}

