/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.chart.swt;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.scada.chart.swt.ChartMouseListener;
import org.eclipse.scada.chart.swt.ChartMouseMoveListener;
import org.eclipse.scada.chart.swt.DisposeListener;
import org.eclipse.scada.chart.swt.Graphics;
import org.eclipse.scada.chart.swt.render.Renderer;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public abstract class ChartRenderer {
    private final List<RendererEntry> renderers = new LinkedList<RendererEntry>();
    private boolean stale;
    private boolean updatePending;
    private boolean disposed;
    private final SizeRenderProxy clientAreaProxy;
    private final Set<DisposeListener> disposeListeners = new LinkedHashSet<DisposeListener>();
    private Color background;
    private String title;

    public ChartRenderer() {
        this.clientAreaProxy = new SizeRenderProxy();
        this.renderers.add(new RendererEntry(this.clientAreaProxy, 0));
    }

    public void resizeAll(Rectangle clientRectangle) {
        for (RendererEntry renderer : this.renderers) {
            renderer.setBounds(clientRectangle);
            Rectangle newBounds = renderer.getRenderer().resize(clientRectangle);
            if (newBounds == null) continue;
            clientRectangle = newBounds;
        }
    }

    protected void checkWidget() {
    }

    public abstract void redraw();

    public abstract Rectangle getClientArea();

    public SizeRenderProxy getClientAreaProxy() {
        return this.clientAreaProxy;
    }

    public void paint(Graphics g) {
        g.setAntialias(true);
        if (this.background != null) {
            g.setBackground(this.background);
            g.fillRectangle(this.getClientArea());
        }
        for (RendererEntry renderer : this.renderers) {
            renderer.render(g);
        }
    }

    public void addRenderer(Renderer renderer) {
        this.addRenderer(renderer, 0);
    }

    public void addRenderer(Renderer renderer, int order) {
        this.checkWidget();
        this.renderers.add(new RendererEntry(renderer, order));
        Collections.sort(this.renderers, new Comparator<RendererEntry>(){

            @Override
            public int compare(RendererEntry o1, RendererEntry o2) {
                return o1.getOrder().compareTo(o2.getOrder());
            }
        });
        this.resizeAll(this.getClientArea());
    }

    public void removeRenderer(Renderer renderer) {
        this.checkWidget();
        Iterator<RendererEntry> i = this.renderers.iterator();
        while (i.hasNext()) {
            RendererEntry entry = i.next();
            if (!entry.getRenderer().equals(renderer)) continue;
            i.remove();
        }
    }

    public void refreshData() {
        this.checkWidget();
        if (this.stale) {
            this.updatePending = true;
        } else {
            this.redraw();
        }
    }

    public void setStale(boolean stale) {
        this.setStale(stale, false);
    }

    public void setStale(boolean stale, boolean forceUpdate) {
        this.checkWidget();
        this.stale = stale;
        if (!stale && (this.updatePending || forceUpdate)) {
            this.updatePending = false;
            this.redraw();
        }
    }

    public void dispose() {
        this.checkWidget();
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        for (final DisposeListener listener : this.disposeListeners) {
            SafeRunnable.getRunner().run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    listener.onDispose();
                }
            });
        }
    }

    public void addDisposeListener(DisposeListener disposeListener) {
        this.checkWidget();
        this.disposeListeners.add(disposeListener);
    }

    public abstract void addMouseListener(ChartMouseListener var1);

    public abstract void removeMouseListener(ChartMouseListener var1);

    public abstract void addMouseMoveListener(ChartMouseMoveListener var1);

    public abstract void removeMouseMoveListener(ChartMouseMoveListener var1);

    public abstract void addMouseWheelListener(MouseWheelListener var1);

    public abstract void removeMouseWheelListener(MouseWheelListener var1);

    public boolean isDisposed() {
        return this.disposed;
    }

    public abstract Display getDisplay();

    public void setChartBackground(Color background) {
        this.background = background;
    }

    public void setFocus() {
    }

    public DropTarget createDropTarget(Transfer[] transfers, DropTargetAdapter createDropTarget) {
        return null;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    private static class RendererEntry {
        private final Integer order;
        private final Renderer renderer;
        private Rectangle bounds;

        public RendererEntry(Renderer renderer, int order) {
            this.renderer = renderer;
            this.order = order;
        }

        public Integer getOrder() {
            return this.order;
        }

        public Renderer getRenderer() {
            return this.renderer;
        }

        public void setBounds(Rectangle bounds) {
            this.bounds = bounds;
        }

        public void render(Graphics g) {
            this.renderer.render(g, this.bounds);
        }
    }

    public static class SizeRenderProxy
    implements Renderer {
        private Rectangle clientRectangle;

        @Override
        public void render(Graphics g, Rectangle clientRectangle) {
        }

        @Override
        public Rectangle resize(Rectangle clientRectangle) {
            this.clientRectangle = clientRectangle;
            return null;
        }

        public Rectangle getClientRectangle() {
            return this.clientRectangle;
        }
    }
}

