/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.chart.swt.render;

import org.eclipse.scada.chart.swt.Graphics;
import org.eclipse.scada.chart.swt.render.Renderer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Rectangle;

public abstract class AbstractRuler
implements Renderer {
    protected Color color;
    protected boolean visible = true;
    private int alpha = 255;
    private static final LineAttributes DEFAULT_LINE_ATTRIBUTES = new LineAttributes(1.0f);
    private LineAttributes lineAttributes = DEFAULT_LINE_ATTRIBUTES;

    public void setLineAttributes(LineAttributes lineAttributes) {
        this.lineAttributes = lineAttributes;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    @Override
    public void render(Graphics g, Rectangle clientRectangle) {
        if (!this.visible) {
            return;
        }
        if (this.color == null) {
            g.setForeground(g.getSystemColor(2));
            g.setBackground(g.getSystemColor(2));
        } else {
            g.setForeground(this.color);
            g.setBackground(this.color);
        }
        g.setAlpha(this.alpha);
        g.setLineAttributes(this.lineAttributes != null ? this.lineAttributes : DEFAULT_LINE_ATTRIBUTES);
        this.doRender(g, clientRectangle);
    }

    protected abstract void doRender(Graphics var1, Rectangle var2);

    @Override
    public Rectangle resize(Rectangle clientRectangle) {
        return null;
    }
}

