/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.blink.internal;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.scada.ui.blink.BlinkCallback;
import org.eclipse.scada.ui.blink.BlinkService;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisplayBlinkServiceImpl
implements BlinkService {
    private static final Logger logger = LoggerFactory.getLogger(DisplayBlinkServiceImpl.class);
    private static final int delay = Integer.getInteger("org.eclipse.scada.ui.utils.toggle.delay", 300);
    private final Set<BlinkCallback> callbacks = new LinkedHashSet<BlinkCallback>();
    private int globalCounter;
    private final Display display;
    private boolean running;
    private final Runnable runnable = new Runnable(){

        @Override
        public void run() {
            DisplayBlinkServiceImpl.this.tick();
        }
    };
    private boolean scheduled;

    public DisplayBlinkServiceImpl(Display display) {
        this.display = display;
    }

    @Override
    public void addListener(BlinkCallback bc) {
        this.checkDisplay();
        this.callbacks.add(bc);
    }

    @Override
    public void removeListener(BlinkCallback bc) {
        this.checkDisplay();
        this.callbacks.remove(bc);
    }

    private void schedule() {
        if (this.scheduled) {
            return;
        }
        this.scheduled = true;
        this.display.timerExec(delay, this.runnable);
    }

    public void start() {
        this.checkDisplay();
        if (this.running) {
            return;
        }
        this.running = true;
        this.schedule();
    }

    public void stop() {
        this.checkDisplay();
        this.running = false;
    }

    protected void tick() {
        this.checkDisplay();
        if (!this.running) {
            return;
        }
        if (!this.scheduled) {
            logger.warn("Got called but was not scheduled");
            return;
        }
        this.processTick();
    }

    private void processTick() {
        this.scheduled = false;
        ++this.globalCounter;
        for (final BlinkCallback tc : this.callbacks) {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    tc.toggle(DisplayBlinkServiceImpl.this.globalCounter);
                }
            });
        }
        this.schedule();
    }

    protected void checkDisplay() {
        if (Display.getCurrent() != this.display) {
            SWT.error((int)22);
        }
    }
}

