/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.connection.provider.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.scada.da.client.ItemManager;
import org.eclipse.scada.da.client.ItemUpdateListener;
import org.eclipse.scada.da.connection.provider.internal.SubscriptionItemEntry;
import org.eclipse.scada.utils.stats.StatisticsImpl;

public class CountingItemManager
implements ItemManager {
    public static final Object REGISTERED_ITEMS = new Object();
    private final ItemManager itemManager;
    private final StatisticsImpl statistics;
    private final Map<SubscriptionItemEntry, Object> itemRegistrationSet = new ConcurrentHashMap<SubscriptionItemEntry, Object>();

    public CountingItemManager(ItemManager itemManager, StatisticsImpl statistics) {
        this.itemManager = itemManager;
        this.statistics = statistics;
    }

    public void addItemUpdateListener(String itemName, ItemUpdateListener listener) {
        this.addItemRegistration(itemName, listener);
        this.itemManager.addItemUpdateListener(itemName, listener);
    }

    public void removeItemUpdateListener(String itemName, ItemUpdateListener listener) {
        this.removeItemRegistration(itemName, listener);
        this.itemManager.removeItemUpdateListener(itemName, listener);
    }

    protected void addItemRegistration(String itemId, ItemUpdateListener listener) {
        this.itemRegistrationSet.put(new SubscriptionItemEntry(itemId, listener), Boolean.TRUE);
        this.statistics.setCurrentValue(REGISTERED_ITEMS, (double)this.itemRegistrationSet.size());
    }

    protected void removeItemRegistration(String itemId, ItemUpdateListener listener) {
        this.itemRegistrationSet.remove(new SubscriptionItemEntry(itemId, listener));
        this.statistics.setCurrentValue(REGISTERED_ITEMS, (double)this.itemRegistrationSet.size());
    }
}

