/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.details.swt.widgets;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.vi.data.DataValue;
import org.eclipse.scada.vi.data.SummaryInformation;
import org.eclipse.scada.vi.details.swt.data.DataItemDescriptor;
import org.eclipse.scada.vi.details.swt.dialog.WriteConfirmDialog;
import org.eclipse.scada.vi.details.swt.widgets.GenericComposite;
import org.eclipse.scada.vi.details.swt.widgets.control.BlockControlImage;
import org.eclipse.scada.vi.details.swt.widgets.control.ControlImage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckComposite
extends GenericComposite {
    private static final Logger logger = LoggerFactory.getLogger(CheckComposite.class);
    private final Button button;
    private final String attribute;
    private final DataItemDescriptor descriptor;
    private final ControlImage controlImage;
    private final BlockControlImage blockImage;

    public CheckComposite(Composite parent, int style, DataItemDescriptor descriptor, String format, String attribute, DataItemDescriptor readDescriptor) {
        super(parent, style, null, null);
        this.attribute = attribute;
        this.descriptor = descriptor;
        RowLayout layout = new RowLayout();
        layout.wrap = false;
        layout.center = true;
        layout.spacing = 3;
        layout.pack = true;
        this.setLayout((Layout)layout);
        this.controlImage = new ControlImage(this, this.registrationManager);
        this.blockImage = new BlockControlImage(this.controlImage, 0, this.registrationManager);
        this.button = new Button((Composite)this, 32);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CheckComposite.this.write();
            }
        });
        this.button.setText(format);
        this.button.setEnabled(false);
        if (descriptor != null) {
            if (readDescriptor != null) {
                this.registrationManager.registerItem("value", readDescriptor.getItemId(), readDescriptor.getConnectionInformation(), false, false);
                this.registrationManager.registerItem("valueWrite", descriptor.getItemId(), descriptor.getConnectionInformation(), false, false);
            } else {
                this.registrationManager.registerItem("value", descriptor.getItemId(), descriptor.getConnectionInformation(), false, false);
            }
            this.blockImage.setBlockItem(descriptor.asItem());
            this.controlImage.setDetailItem(descriptor.asItem());
        }
    }

    protected void write() {
        if (!WriteConfirmDialog.create(this.getShell())) {
            return;
        }
        try {
            this.button.setEnabled(false);
            if (this.attribute == null || this.attribute.equals("")) {
                this.registrationManager.startWrite(this.descriptor.getConnectionInformation(), this.descriptor.getItemId(), Variant.valueOf((boolean)this.button.getSelection()), this.callbackHandler);
            } else {
                HashMap<String, Variant> map = new HashMap<String, Variant>();
                map.put(this.attribute, Variant.valueOf((boolean)this.button.getSelection()));
                this.registrationManager.startWriteAttributes(this.descriptor.getConnectionInformation(), this.descriptor.getItemId(), map, this.callbackHandler);
            }
            this.getShell().setFocus();
        }
        catch (Exception exception) {}
    }

    @Override
    protected void updateState(Map<String, DataValue> values, SummaryInformation state) {
        Variant value;
        if (this.isDisposed()) {
            logger.info("No updateView cause widget is disposed");
            return;
        }
        if (this.attribute == null) {
            try {
                value = values.get("value").getValue().getValue();
            }
            catch (NullPointerException e) {
                logger.info("could not get value", (Throwable)e);
                value = Variant.NULL;
            }
        } else {
            try {
                value = (Variant)values.get("value").getValue().getAttributes().get(this.attribute);
            }
            catch (NullPointerException e) {
                logger.info("could not get attribute", (Throwable)e);
                value = Variant.NULL;
            }
        }
        if (value == null) {
            return;
        }
        this.button.setSelection(value.asBoolean());
        this.button.setEnabled(!state.isBlocked());
    }
}

