/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.ui.user.navigation;

import java.util.EnumSet;
import java.util.Set;
import org.eclipse.scada.core.ui.styles.StateInformation;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.ui.connection.data.DataItemHolder;
import org.eclipse.scada.da.ui.connection.data.DataSourceListener;
import org.eclipse.scada.da.ui.connection.data.Item;
import org.eclipse.scada.da.ui.styles.DataItemValueStateExtractor;
import org.eclipse.scada.vi.ui.user.Activator;
import org.eclipse.scada.vi.ui.user.navigation.StateListener;
import org.eclipse.scada.vi.ui.user.navigation.StateProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemSummaryProvider
implements StateProvider {
    private static final Logger logger = LoggerFactory.getLogger(ItemSummaryProvider.class);
    private final StateListener stateListener;
    private final DataSourceListener listener = new DataSourceListener(){

        public void updateData(DataItemValue value) {
            ItemSummaryProvider.this.handleValueChange(value);
        }
    };
    private final DataItemHolder itemHolder;

    public ItemSummaryProvider(StateListener stateListener, Item item) {
        this.stateListener = stateListener;
        stateListener.stateChange(new StateInformation(){

            public Set<StateInformation.State> getStates() {
                return EnumSet.of(StateInformation.State.DISCONNECTED);
            }
        });
        this.itemHolder = new DataItemHolder(Activator.getDefault().getBundle().getBundleContext(), item, this.listener);
    }

    protected void handleValueChange(DataItemValue value) {
        logger.debug("Summary item value changed: {}", (Object)value);
        if (this.listener == null) {
            return;
        }
        this.stateListener.stateChange((StateInformation)new DataItemValueStateExtractor(value));
    }

    @Override
    public void dispose() {
        this.itemHolder.dispose();
    }
}

