/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.ui.user.navigation.breadcrumb;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.vi.ui.user.navigation.breadcrumb.BreadcrumbBar;
import org.eclipse.scada.vi.ui.user.navigation.breadcrumb.Messages;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class BreadcrumbItem {
    private final Composite wrapper;
    private final CLabel item;
    private final BreadcrumbBar parent;
    private final boolean horizontal;
    private final Map<String, Object> data = new HashMap<String, Object>();

    public BreadcrumbItem(BreadcrumbBar parent, boolean last) {
        this.horizontal = parent.isHorizontal();
        this.parent = parent;
        this.wrapper = new Composite(parent.getComposite(), 0);
        parent.addChild(this);
        GridLayout layout = new GridLayout(last ? 1 : 2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        if (this.horizontal) {
            layout.horizontalSpacing = 5;
        } else {
            layout.verticalSpacing = 5;
        }
        this.wrapper.setLayout((Layout)layout);
        this.item = new CLabel(this.wrapper, 0);
        this.item.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        if (!last) {
            Label label = new Label(this.wrapper, 0);
            if (this.horizontal) {
                label.setText(Messages.BreadcrumbNavigator_Splitter_Horizontal);
            } else {
                label.setText(Messages.BreadcrumbNavigator_Splitter_Vertical);
            }
            label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        }
        if (this.horizontal) {
            this.wrapper.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        } else {
            this.wrapper.setLayoutData((Object)new GridData(4, 1, true, false));
        }
        this.item.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                BreadcrumbItem.this.handleSelected();
            }
        });
    }

    protected void handleSelected() {
        this.parent.selectItem(this, true);
    }

    public void setText(String text) {
        this.item.setText(text);
    }

    public void setImage(Image image) {
        this.item.setImage(image);
    }

    public void dispose() {
        this.parent.removeChild(this);
        this.wrapper.dispose();
    }

    public void setData(String key, Object value) {
        this.data.put(key, value);
    }

    public Object getData(String key) {
        return this.data.get(key);
    }

    public void setSelected(boolean selected) {
        this.parent.selectItem(this, selected);
    }

    void handleSetSelection(boolean selected) {
        if (selected) {
            this.item.setBackground(this.item.getDisplay().getSystemColor(26));
            this.item.setForeground(this.item.getDisplay().getSystemColor(27));
            this.item.setCursor(null);
        } else {
            this.item.setBackground(null);
            this.item.setForeground(null);
            this.item.setCursor(this.item.getDisplay().getSystemCursor(21));
        }
    }
}

