/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.client.ngp;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.scada.ae.client.EventListener;
import org.eclipse.scada.ae.client.ngp.ConnectionImpl;
import org.eclipse.scada.ae.client.ngp.Events;
import org.eclipse.scada.ae.data.EventInformation;
import org.eclipse.scada.core.data.SubscriptionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventManager {
    private static final Logger logger = LoggerFactory.getLogger(EventManager.class);
    private final Map<String, EventListener> eventListeners = new HashMap<String, EventListener>();
    private final Executor executor;
    private final ConnectionImpl connection;

    public EventManager(Executor executor, ConnectionImpl connection) {
        this.executor = executor;
        this.connection = connection;
    }

    public void setEventListener(String eventQueryId, EventListener listener) {
        if (listener == null) {
            this.clearEventListener(eventQueryId);
        } else {
            this.updateEventListener(eventQueryId, listener);
        }
    }

    private void updateEventListener(String eventQueryId, EventListener listener) {
        logger.debug("Update event listener for {}", (Object)eventQueryId);
        EventListener oldListener = this.eventListeners.put(eventQueryId, listener);
        if (oldListener == listener) {
            return;
        }
        if (oldListener != null) {
            this.fireEventStatusChange(oldListener, SubscriptionState.DISCONNECTED);
        } else {
            this.sendSubscribeEvents(eventQueryId, true);
        }
        this.fireEventStatusChange(listener, SubscriptionState.DISCONNECTED);
    }

    private void clearEventListener(String eventQueryId) {
        logger.debug("Clear event listener for {}", (Object)eventQueryId);
        EventListener oldListener = this.eventListeners.remove(eventQueryId);
        if (oldListener != null) {
            this.sendSubscribeEvents(eventQueryId, false);
        }
        if (oldListener != null) {
            this.fireEventStatusChange(oldListener, SubscriptionState.DISCONNECTED);
        }
    }

    private void fireEventStatusChange(final EventListener listener, final SubscriptionState status) {
        if (listener == null) {
            return;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                listener.statusChanged(status);
            }
        });
    }

    private void sendSubscribeEvents(String eventQueryId, boolean flag) {
        logger.info("Requesting events: {}/{}", (Object)eventQueryId, (Object)flag);
        if (flag) {
            this.connection.sendSubscribeEventPool(eventQueryId);
        } else {
            this.connection.sendUnsubscribeEventPool(eventQueryId);
        }
    }

    private void fireEventDataChange(final EventListener listener, final List<EventInformation> added) {
        if (listener == null) {
            logger.warn("Event change data without a listener");
            return;
        }
        try {
            logger.debug("notify condition data change");
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    listener.dataChanged(Events.convertToEvent(added));
                }
            });
        }
        catch (Throwable e) {
            logger.warn("Failed to notify", e);
        }
    }

    public void dispose() {
        logger.debug("Dispose");
        this.onClosed();
        this.eventListeners.clear();
    }

    public void onClosed() {
        for (EventListener listener : this.eventListeners.values()) {
            this.fireEventStatusChange(listener, SubscriptionState.DISCONNECTED);
        }
    }

    public void onBound() {
        for (String id : this.eventListeners.keySet()) {
            this.connection.sendSubscribeMonitorPool(id);
        }
    }

    public void handleDataUpdate(String eventQueryId, List<EventInformation> added) {
        EventListener listener = this.eventListeners.get(eventQueryId);
        this.fireEventDataChange(listener, added);
    }

    public void handleStatusUpdate(String eventQueryId, SubscriptionState state) {
        EventListener listener = this.eventListeners.get(eventQueryId);
        this.fireEventStatusChange(listener, state);
    }
}

