/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.client;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import org.eclipse.scada.core.AttributesHelper;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.client.ItemManager;
import org.eclipse.scada.da.client.ItemUpdateListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataItem
extends Observable {
    private static final String PROP_VALUE = "snapshotValue";
    private static final Logger logger = LoggerFactory.getLogger(DataItem.class);
    private final String itemId;
    private ItemManager itemManager;
    private volatile DataItemValue value = DataItemValue.DISCONNECTED;
    private final ItemUpdateListener listener;
    private final PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);

    public DataItem(String itemId) {
        this.itemId = itemId;
        this.listener = new ItemUpdateListener(){

            @Override
            public void notifyDataChange(Variant value, Map<String, Variant> attributes, boolean cache) {
                DataItem.this.performNotifyDataChange(value, attributes, cache);
            }

            @Override
            public void notifySubscriptionChange(SubscriptionState subscriptionState, Throwable subscriptionError) {
                DataItem.this.performNotifySubscriptionChange(subscriptionState, subscriptionError);
            }
        };
    }

    public DataItem(String itemId, ItemManager itemManager) {
        this(itemId);
        if (itemManager != null) {
            this.register(itemManager);
        }
    }

    public void register(ItemManager itemManager) {
        if (this.itemManager == itemManager) {
            return;
        }
        this.unregister();
        this.itemManager = itemManager;
        this.itemManager.addItemUpdateListener(this.itemId, this.listener);
    }

    public void unregister() {
        ItemManager manager = this.itemManager;
        this.itemManager = null;
        if (manager != null) {
            manager.removeItemUpdateListener(this.itemId, this.listener);
        }
    }

    protected void handlePerformNotifyDataChange(Variant value, Map<String, Variant> attributes, boolean cache) {
        DataItemValue.Builder newValue = new DataItemValue.Builder(this.value);
        if (cache) {
            this.setChanged();
            newValue.setAttributes(new HashMap<String, Variant>(attributes));
        } else {
            AttributesHelper.mergeAttributes(newValue.getAttributes(), attributes);
        }
        if (attributes != null) {
            this.setChanged();
        }
        if (value != null) {
            this.setChanged();
            newValue.setValue(value);
        }
        DataItemValue oldValue = this.value;
        this.value = newValue.build();
        try {
            this.notifyObservers(this.value);
            this.propertySupport.firePropertyChange(PROP_VALUE, oldValue, this.value);
        }
        catch (Throwable e) {
            logger.warn("Failed to notify data change", e);
        }
    }

    protected void performNotifyDataChange(Variant value, Map<String, Variant> attributes, boolean cache) {
        this.handlePerformNotifyDataChange(value, attributes, cache);
    }

    protected void handlePerformNotifySubscriptionChange(SubscriptionState subscriptionState, Throwable subscriptionError) {
        DataItemValue.Builder newValue = new DataItemValue.Builder(this.value);
        newValue.setSubscriptionState(subscriptionState);
        newValue.setSubscriptionError(subscriptionError);
        DataItemValue oldValue = this.value;
        this.value = newValue.build();
        this.setChanged();
        try {
            this.notifyObservers(this.value);
            this.propertySupport.firePropertyChange(PROP_VALUE, oldValue, this.value);
        }
        catch (Throwable e) {
            logger.warn("Failed to notify subscription change", e);
        }
    }

    protected void performNotifySubscriptionChange(SubscriptionState subscriptionState, Throwable subscriptionError) {
        this.handlePerformNotifySubscriptionChange(subscriptionState, subscriptionError);
    }

    public DataItemValue getSnapshotValue() {
        return this.value;
    }

    @Deprecated
    public Map<String, Variant> getAttributes() {
        return this.value.getAttributes();
    }

    @Deprecated
    public SubscriptionState getSubscriptionState() {
        return this.value.getSubscriptionState();
    }

    public String getItemId() {
        return this.itemId;
    }

    @Deprecated
    public Throwable getSubscriptionError() {
        return this.value.getSubscriptionError();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(propertyName, listener);
    }
}

