/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.core.AttributesHelper;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.da.client.Connection;
import org.eclipse.scada.da.client.ItemManagerImpl;
import org.eclipse.scada.da.client.ItemUpdateListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemSyncController
implements ItemUpdateListener {
    private static final Logger logger = LoggerFactory.getLogger(ItemSyncController.class);
    private final Connection connection;
    private final String itemId;
    private boolean subscribed;
    private Variant cachedValue = Variant.NULL;
    private final Map<String, Variant> cachedAttributes = new HashMap<String, Variant>(0);
    private SubscriptionState subscriptionState = SubscriptionState.DISCONNECTED;
    private Throwable subscriptionError;
    private final Map<ItemUpdateListener, ListenerInfo> listeners = new HashMap<ItemUpdateListener, ListenerInfo>(0);
    private final ItemManagerImpl itemManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemSyncController(Connection connection, ItemManagerImpl itemManager, String itemId) {
        this.connection = connection;
        this.itemManager = itemManager;
        this.itemId = itemId;
        ItemSyncController itemSyncController = this;
        synchronized (itemSyncController) {
            this.connection.setItemUpdateListener(this.itemId, this);
        }
    }

    public String getItemName() {
        return this.itemId;
    }

    public synchronized void add(final ItemUpdateListener listener) {
        if (!this.listeners.containsKey(listener)) {
            this.listeners.put(listener, new ListenerInfo(listener));
            final SubscriptionState state = this.subscriptionState;
            final Throwable error = this.subscriptionError;
            final Variant value = this.cachedValue;
            final HashMap<String, Variant> attributes = new HashMap<String, Variant>(this.cachedAttributes);
            logger.trace("Sending out cache values - itemId: {}, state: {}, value: {}, attributes: {}", new Object[]{this.itemId, state, value, attributes});
            this.itemManager.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    listener.notifySubscriptionChange(state, error);
                    listener.notifyDataChange(value, attributes, true);
                }
            });
            this.sync(false);
        }
    }

    public synchronized void remove(ItemUpdateListener listener) {
        ListenerInfo result = this.listeners.remove(listener);
        if (result != null) {
            this.sync(false);
        }
    }

    public synchronized void sync(boolean force) {
        boolean subscribe;
        boolean bl = subscribe = !this.listeners.isEmpty();
        if (this.subscribed == subscribe && !force) {
            return;
        }
        if (subscribe) {
            this.subscribe();
        } else {
            this.unsubscribe();
        }
    }

    protected synchronized void subscribe() {
        try {
            logger.debug("Syncing listen state: active");
            this.subscribed = true;
            this.connection.subscribeItem(this.itemId);
        }
        catch (Throwable e) {
            this.handleError(e);
        }
    }

    protected synchronized void unsubscribe() {
        try {
            logger.debug("Syncing listen state: inactive");
            this.subscribed = false;
            this.cachedValue = null;
            this.cachedAttributes.clear();
            this.notifySubscriptionChange(SubscriptionState.DISCONNECTED, null);
            this.connection.unsubscribeItem(this.itemId);
        }
        catch (Throwable e) {
            logger.warn("Failed to handle unsubscribe", e);
        }
    }

    private synchronized void handleError(Throwable e) {
        logger.warn("Failed to change subscription state", e);
        this.subscribed = false;
        this.notifySubscriptionChange(SubscriptionState.DISCONNECTED, e);
    }

    @Override
    public synchronized void notifyDataChange(final Variant value, final Map<String, Variant> attributes, final boolean cache) {
        boolean change = false;
        if (this.cachedValue == null || !this.cachedValue.equals((Object)value)) {
            change = true;
            this.cachedValue = value;
        }
        if (attributes != null && (!attributes.isEmpty() || cache)) {
            AttributesHelper.mergeAttributes(this.cachedAttributes, attributes, (boolean)cache);
            change = true;
        }
        if (change) {
            final ListenerInfo[] listeners = this.listeners.values().toArray(new ListenerInfo[this.listeners.size()]);
            this.itemManager.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    ListenerInfo[] listenerInfoArray = listeners;
                    int n = listeners.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ListenerInfo listenerInfo = listenerInfoArray[n2];
                        try {
                            listenerInfo.getListener().notifyDataChange(value, attributes, cache);
                        }
                        catch (Exception e) {
                            logger.info("Failed to notify listener for data change", (Throwable)e);
                        }
                        ++n2;
                    }
                }
            });
        }
    }

    @Override
    public synchronized void notifySubscriptionChange(final SubscriptionState subscriptionState, final Throwable e) {
        if (this.subscriptionState.equals((Object)subscriptionState) && this.subscriptionError == e) {
            return;
        }
        this.subscriptionState = subscriptionState;
        this.subscriptionError = e;
        final ListenerInfo[] listeners = this.listeners.values().toArray(new ListenerInfo[this.listeners.size()]);
        this.itemManager.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                ListenerInfo[] listenerInfoArray = listeners;
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    ListenerInfo listenerInfo = listenerInfoArray[n2];
                    try {
                        listenerInfo.getListener().notifySubscriptionChange(subscriptionState, e);
                    }
                    catch (Exception e2) {
                        logger.info("Failed to notify listener subscription change", (Throwable)e2);
                    }
                    ++n2;
                }
            }
        });
    }

    public synchronized void disconnect() {
        this.notifySubscriptionChange(SubscriptionState.DISCONNECTED, null);
        this.notifyDataChange(Variant.NULL, Collections.<String, Variant>emptyMap(), true);
    }

    private static class ListenerInfo {
        private final ItemUpdateListener listener;

        public ListenerInfo(ItemUpdateListener listener) {
            this.listener = listener;
        }

        public ItemUpdateListener getListener() {
            return this.listener;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj instanceof ItemUpdateListener) {
                return obj == this.listener;
            }
            if (obj instanceof ListenerInfo) {
                return ((ListenerInfo)obj).listener == this.listener;
            }
            return false;
        }

        public int hashCode() {
            return this.listener.hashCode();
        }
    }
}

