/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.protocol.ngp.codec;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.ae.data.BrowserEntry;
import org.eclipse.scada.ae.data.BrowserType;
import org.eclipse.scada.ae.data.EventInformation;
import org.eclipse.scada.ae.data.MonitorStatus;
import org.eclipse.scada.ae.data.MonitorStatusInformation;
import org.eclipse.scada.ae.data.Severity;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.ngp.common.codec.osbp.BinaryContext;
import org.eclipse.scada.protocol.ngp.common.utils.ArrayListAllocator;
import org.eclipse.scada.protocol.ngp.common.utils.CollectionAllocator;
import org.eclipse.scada.protocol.ngp.common.utils.HashSetAllocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Structures {
    private static final Logger logger = LoggerFactory.getLogger(Structures.class);
    private static final ArrayListAllocator<MonitorStatusInformation> ALLOC_MONITORSTATUSINFORMATION_LIST = new ArrayListAllocator();
    private static final HashSetAllocator<MonitorStatusInformation> ALLOC_MONITORSTATUSINFORMATION_SET = new HashSetAllocator();
    private static final ArrayListAllocator<BrowserEntry> ALLOC_BROWSERENTRY_LIST = new ArrayListAllocator();
    private static final HashSetAllocator<BrowserEntry> ALLOC_BROWSERENTRY_SET = new HashSetAllocator();
    private static final ArrayListAllocator<EventInformation> ALLOC_EVENTINFORMATION_LIST = new ArrayListAllocator();
    private static final HashSetAllocator<EventInformation> ALLOC_EVENTINFORMATION_SET = new HashSetAllocator();

    private Structures() {
    }

    protected static void inlineEncodeMonitorStatusInformation(BinaryContext context, IoBuffer data, MonitorStatusInformation value) throws Exception {
        data.put((byte)10);
        context.encodeString(data, (byte)1, value.getId());
        context.encodeEnum(data, (byte)2, (Enum)value.getStatus());
        context.encodePrimitiveLong(data, (byte)3, value.getStatusTimestamp());
        context.encodeEnum(data, (byte)4, (Enum)value.getSeverity());
        context.encodeVariant(data, (byte)5, value.getValue());
        context.encodeLong(data, (byte)6, value.getLastAknTimestamp());
        context.encodeString(data, (byte)7, value.getLastAknUser());
        context.encodeLong(data, (byte)8, value.getLastFailTimestamp());
        context.encodeVariant(data, (byte)10, value.getLastFailValue());
        context.encodeVariantMap(data, (byte)9, value.getAttributes());
    }

    protected static MonitorStatusInformation inlindeDecodeMonitorStatusInformation(BinaryContext _context, IoBuffer _data) throws Exception {
        int numberOfFields = _data.get();
        String id = null;
        MonitorStatus status = null;
        long statusTimestamp = 0L;
        Severity severity = null;
        Variant value = null;
        Long lastAknTimestamp = null;
        String lastAknUser = null;
        Long lastFailTimestamp = null;
        Variant lastFailValue = null;
        Map attributes = null;
        logger.trace("Decoding {} fields", (Object)((byte)numberOfFields));
        int i = 0;
        while (i < numberOfFields) {
            byte fieldNumber = _data.get();
            switch (fieldNumber) {
                case 1: {
                    id = _context.decodeString(_data);
                    break;
                }
                case 2: {
                    status = (MonitorStatus)_context.decodeEnum(_data, MonitorStatus.class);
                    break;
                }
                case 3: {
                    statusTimestamp = _context.decodePrimitiveLong(_data);
                    break;
                }
                case 4: {
                    severity = (Severity)_context.decodeEnum(_data, Severity.class);
                    break;
                }
                case 5: {
                    value = _context.decodeVariant(_data);
                    break;
                }
                case 6: {
                    lastAknTimestamp = _context.decodeLong(_data);
                    break;
                }
                case 7: {
                    lastAknUser = _context.decodeString(_data);
                    break;
                }
                case 8: {
                    lastFailTimestamp = _context.decodeLong(_data);
                    break;
                }
                case 10: {
                    lastFailValue = _context.decodeVariant(_data);
                    break;
                }
                case 9: {
                    attributes = _context.decodeVariantMap(_data);
                    break;
                }
                default: {
                    logger.warn("Received unknown field number: {}", (Object)fieldNumber);
                }
            }
            ++i;
        }
        return new MonitorStatusInformation(id, status, statusTimestamp, severity, value, lastAknTimestamp, lastAknUser, lastFailTimestamp, lastFailValue, attributes);
    }

    public static void encodeMonitorStatusInformation(BinaryContext context, IoBuffer data, byte fieldNumber, MonitorStatusInformation value) throws Exception {
        context.beginWriteStructure(data, fieldNumber, value == null);
        if (value != null) {
            Structures.inlineEncodeMonitorStatusInformation(context, data, value);
        }
    }

    public static void encodeCollectionMonitorStatusInformation(BinaryContext context, IoBuffer data, byte fieldNumber, Collection<MonitorStatusInformation> values) throws Exception {
        context.beginWriteStructureList(data, fieldNumber, values);
        if (values == null) {
            return;
        }
        for (MonitorStatusInformation entry : values) {
            Structures.inlineEncodeMonitorStatusInformation(context, data, entry);
        }
    }

    public static MonitorStatusInformation decodeMonitorStatusInformation(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        boolean isNull = context.beginReadStructure(data, allowNull);
        if (isNull) {
            return null;
        }
        return Structures.inlindeDecodeMonitorStatusInformation(context, data);
    }

    protected static void fillMonitorStatusInformationCollection(BinaryContext context, IoBuffer data, int items, Collection<MonitorStatusInformation> values) throws Exception {
        int i = 0;
        while (i < items) {
            values.add(Structures.inlindeDecodeMonitorStatusInformation(context, data));
            ++i;
        }
    }

    protected static <T extends Collection<MonitorStatusInformation>> T decodeMonitorStatusInformationCollection(BinaryContext context, IoBuffer data, CollectionAllocator<MonitorStatusInformation, T> allactor, boolean allowNull) throws Exception {
        Integer len = context.beginReadStructureList(data, allowNull);
        if (len == null) {
            return null;
        }
        Collection result = allactor.allocate(len.intValue());
        Structures.fillMonitorStatusInformationCollection(context, data, len, result);
        return (T)result;
    }

    public static List<MonitorStatusInformation> decodeListMonitorStatusInformation(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        return (List)Structures.decodeMonitorStatusInformationCollection(context, data, ALLOC_MONITORSTATUSINFORMATION_LIST, allowNull);
    }

    public static Set<MonitorStatusInformation> decodeSetMonitorStatusInformation(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        return (Set)Structures.decodeMonitorStatusInformationCollection(context, data, ALLOC_MONITORSTATUSINFORMATION_SET, allowNull);
    }

    protected static void inlineEncodeBrowserEntry(BinaryContext context, IoBuffer data, BrowserEntry value) throws Exception {
        data.put((byte)3);
        context.encodeString(data, (byte)1, value.getId());
        context.encodeEnumSet(data, (byte)2, value.getTypes());
        context.encodeVariantMap(data, (byte)3, value.getAttributes());
    }

    protected static BrowserEntry inlindeDecodeBrowserEntry(BinaryContext _context, IoBuffer _data) throws Exception {
        int numberOfFields = _data.get();
        String id = null;
        Set types = null;
        Map attributes = null;
        logger.trace("Decoding {} fields", (Object)((byte)numberOfFields));
        int i = 0;
        while (i < numberOfFields) {
            byte fieldNumber = _data.get();
            switch (fieldNumber) {
                case 1: {
                    id = _context.decodeString(_data);
                    break;
                }
                case 2: {
                    types = _context.decodeEnumSet(_data, BrowserType.class);
                    break;
                }
                case 3: {
                    attributes = _context.decodeVariantMap(_data);
                    break;
                }
                default: {
                    logger.warn("Received unknown field number: {}", (Object)fieldNumber);
                }
            }
            ++i;
        }
        return new BrowserEntry(id, types, attributes);
    }

    public static void encodeBrowserEntry(BinaryContext context, IoBuffer data, byte fieldNumber, BrowserEntry value) throws Exception {
        context.beginWriteStructure(data, fieldNumber, value == null);
        if (value != null) {
            Structures.inlineEncodeBrowserEntry(context, data, value);
        }
    }

    public static void encodeCollectionBrowserEntry(BinaryContext context, IoBuffer data, byte fieldNumber, Collection<BrowserEntry> values) throws Exception {
        context.beginWriteStructureList(data, fieldNumber, values);
        if (values == null) {
            return;
        }
        for (BrowserEntry entry : values) {
            Structures.inlineEncodeBrowserEntry(context, data, entry);
        }
    }

    public static BrowserEntry decodeBrowserEntry(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        boolean isNull = context.beginReadStructure(data, allowNull);
        if (isNull) {
            return null;
        }
        return Structures.inlindeDecodeBrowserEntry(context, data);
    }

    protected static void fillBrowserEntryCollection(BinaryContext context, IoBuffer data, int items, Collection<BrowserEntry> values) throws Exception {
        int i = 0;
        while (i < items) {
            values.add(Structures.inlindeDecodeBrowserEntry(context, data));
            ++i;
        }
    }

    protected static <T extends Collection<BrowserEntry>> T decodeBrowserEntryCollection(BinaryContext context, IoBuffer data, CollectionAllocator<BrowserEntry, T> allactor, boolean allowNull) throws Exception {
        Integer len = context.beginReadStructureList(data, allowNull);
        if (len == null) {
            return null;
        }
        Collection result = allactor.allocate(len.intValue());
        Structures.fillBrowserEntryCollection(context, data, len, result);
        return (T)result;
    }

    public static List<BrowserEntry> decodeListBrowserEntry(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        return (List)Structures.decodeBrowserEntryCollection(context, data, ALLOC_BROWSERENTRY_LIST, allowNull);
    }

    public static Set<BrowserEntry> decodeSetBrowserEntry(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        return (Set)Structures.decodeBrowserEntryCollection(context, data, ALLOC_BROWSERENTRY_SET, allowNull);
    }

    protected static void inlineEncodeEventInformation(BinaryContext context, IoBuffer data, EventInformation value) throws Exception {
        data.put((byte)4);
        context.encodeString(data, (byte)1, value.getId());
        context.encodePrimitiveLong(data, (byte)2, value.getSourceTimestamp());
        context.encodePrimitiveLong(data, (byte)3, value.getEntryTimestamp());
        context.encodeVariantMap(data, (byte)4, value.getAttributes());
    }

    protected static EventInformation inlindeDecodeEventInformation(BinaryContext _context, IoBuffer _data) throws Exception {
        int numberOfFields = _data.get();
        String id = null;
        long sourceTimestamp = 0L;
        long entryTimestamp = 0L;
        Map attributes = null;
        logger.trace("Decoding {} fields", (Object)((byte)numberOfFields));
        int i = 0;
        while (i < numberOfFields) {
            byte fieldNumber = _data.get();
            switch (fieldNumber) {
                case 1: {
                    id = _context.decodeString(_data);
                    break;
                }
                case 2: {
                    sourceTimestamp = _context.decodePrimitiveLong(_data);
                    break;
                }
                case 3: {
                    entryTimestamp = _context.decodePrimitiveLong(_data);
                    break;
                }
                case 4: {
                    attributes = _context.decodeVariantMap(_data);
                    break;
                }
                default: {
                    logger.warn("Received unknown field number: {}", (Object)fieldNumber);
                }
            }
            ++i;
        }
        return new EventInformation(id, sourceTimestamp, entryTimestamp, attributes);
    }

    public static void encodeEventInformation(BinaryContext context, IoBuffer data, byte fieldNumber, EventInformation value) throws Exception {
        context.beginWriteStructure(data, fieldNumber, value == null);
        if (value != null) {
            Structures.inlineEncodeEventInformation(context, data, value);
        }
    }

    public static void encodeCollectionEventInformation(BinaryContext context, IoBuffer data, byte fieldNumber, Collection<EventInformation> values) throws Exception {
        context.beginWriteStructureList(data, fieldNumber, values);
        if (values == null) {
            return;
        }
        for (EventInformation entry : values) {
            Structures.inlineEncodeEventInformation(context, data, entry);
        }
    }

    public static EventInformation decodeEventInformation(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        boolean isNull = context.beginReadStructure(data, allowNull);
        if (isNull) {
            return null;
        }
        return Structures.inlindeDecodeEventInformation(context, data);
    }

    protected static void fillEventInformationCollection(BinaryContext context, IoBuffer data, int items, Collection<EventInformation> values) throws Exception {
        int i = 0;
        while (i < items) {
            values.add(Structures.inlindeDecodeEventInformation(context, data));
            ++i;
        }
    }

    protected static <T extends Collection<EventInformation>> T decodeEventInformationCollection(BinaryContext context, IoBuffer data, CollectionAllocator<EventInformation, T> allactor, boolean allowNull) throws Exception {
        Integer len = context.beginReadStructureList(data, allowNull);
        if (len == null) {
            return null;
        }
        Collection result = allactor.allocate(len.intValue());
        Structures.fillEventInformationCollection(context, data, len, result);
        return (T)result;
    }

    public static List<EventInformation> decodeListEventInformation(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        return (List)Structures.decodeEventInformationCollection(context, data, ALLOC_EVENTINFORMATION_LIST, allowNull);
    }

    public static Set<EventInformation> decodeSetEventInformation(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        return (Set)Structures.decodeEventInformationCollection(context, data, ALLOC_EVENTINFORMATION_SET, allowNull);
    }
}

