/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.utils.datetime;

import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DateTimeDialog
extends Dialog {
    private Label resultControl;
    private Text input;
    private Calendar time;

    public DateTimeDialog(Shell shell) {
        super(shell);
    }

    public DateTimeDialog(IShellProvider shellProvider) {
        super(shellProvider);
    }

    public void setTime(Calendar time) {
        this.time = time;
    }

    public void setTime(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        this.time = c;
    }

    public void setTime(long millis) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(millis);
        this.time = c;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Time and date");
        Composite base = (Composite)super.createDialogArea(parent);
        Composite wrapper = new Composite(base, 0);
        wrapper.setLayout((Layout)new GridLayout(2, false));
        wrapper.setLayoutData((Object)new GridData(1808));
        Label label = new Label(wrapper, 0);
        label.setText("Input:");
        this.input = new Text(wrapper, 2048);
        this.input.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DateTimeDialog.this.update();
            }
        });
        this.input.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.resultControl = new Label(wrapper, 0);
        this.resultControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        if (this.time != null) {
            this.input.setText(String.format("%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS.%1$tL", this.time));
        }
        return base;
    }

    protected void update() {
        String str = this.input.getText();
        Calendar c = this.parse(str);
        this.setCalendar(c);
    }

    protected Calendar parse(String str) {
        try {
            Calendar c = this.tryParse(str, "(\\d{1,2}):(\\d{1,2})", new int[]{11, 12}, new int[]{1, 2});
            if (c != null) {
                return c;
            }
            c = this.tryParse(str, "(\\d{1,2}):(\\d{1,2}):(\\d{1,2})", new int[]{11, 12, 13}, new int[]{1, 2, 3});
            if (c != null) {
                return c;
            }
            c = this.tryParse(str, "(\\d{1,2}):(\\d{1,2}):(\\d{1,2})\\.(\\d{1,3})", new int[]{11, 12, 13, 14}, new int[]{1, 2, 3, 4});
            if (c != null) {
                return c;
            }
            c = this.tryParse(str, "(\\d{4})", new int[]{1}, new int[]{1});
            if (c != null) {
                return c;
            }
            c = this.tryParse(str, "(\\d{4})-(\\d{2})", new int[]{1, 2}, new int[]{1, 2});
            if (c != null) {
                return c;
            }
            c = this.tryParse(str, "(\\d{4})-(\\d{2})-(\\d{2})", new int[]{1, 2, 5}, new int[]{1, 2, 3});
            if (c != null) {
                return c;
            }
            c = this.tryParse(str, "(\\d{4})-(\\d{2})-(\\d{2}) +(\\d{1,2})", new int[]{1, 2, 5, 11}, new int[]{1, 2, 3, 4});
            if (c != null) {
                return c;
            }
            c = this.tryParse(str, "(\\d{4})-(\\d{2})-(\\d{2}) +(\\d{1,2}):(\\d{1,2})", new int[]{1, 2, 5, 11, 12}, new int[]{1, 2, 3, 4, 5});
            if (c != null) {
                return c;
            }
            c = this.tryParse(str, "(\\d{4})-(\\d{2})-(\\d{2}) +(\\d{1,2}):(\\d{1,2}):(\\d{1,2})", new int[]{1, 2, 5, 11, 12, 13}, new int[]{1, 2, 3, 4, 5, 6});
            if (c != null) {
                return c;
            }
            c = this.tryParse(str, "(\\d{4})-(\\d{2})-(\\d{2}) +(\\d{1,2}):(\\d{1,2}):(\\d{1,2})\\.(\\d{1,3})", new int[]{1, 2, 5, 11, 12, 13, 14}, new int[]{1, 2, 3, 4, 5, 6, 7});
            if (c != null) {
                return c;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Calendar tryParse(String str, String exp, int[] is, int[] is2) {
        Matcher m = Pattern.compile(exp).matcher(str);
        if (m.matches()) {
            String[] data = new String[is2.length];
            int i = 0;
            while (i < is2.length) {
                data[i] = m.group(is2[i]);
                ++i;
            }
            return this.makeCalendar(is, data);
        }
        return null;
    }

    private Calendar makeCalendar(int[] is, String[] strings) {
        Calendar c = Calendar.getInstance();
        if (is.length != strings.length) {
            throw new IllegalArgumentException("Array length is not equal. Internal error.");
        }
        int i = 0;
        while (i < is.length) {
            if (is[i] == 2) {
                c.set(is[i], Integer.parseInt(strings[i]) - 1);
            } else {
                c.set(is[i], Integer.parseInt(strings[i]));
            }
            ++i;
        }
        return c;
    }

    private void setCalendar(Calendar c) {
        this.time = c;
        if (c != null) {
            this.resultControl.setText(String.format("%tc", c));
        } else {
            this.resultControl.setText("<none>");
        }
    }

    public Calendar getCalendar() {
        return this.time;
    }

    public Date getDate() {
        Calendar c = this.getCalendar();
        if (c == null) {
            return null;
        }
        return c.getTime();
    }
}

