/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.protocol.ngp.codec.impl;

import java.util.List;
import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.core.data.CallbackRequest;
import org.eclipse.scada.core.data.Request;
import org.eclipse.scada.core.ngp.common.codec.osbp.BinaryContext;
import org.eclipse.scada.core.ngp.common.codec.osbp.BinaryMessageCodec;
import org.eclipse.scada.core.protocol.ngp.codec.Structures;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestCallbacks
implements BinaryMessageCodec {
    private static final Logger logger = LoggerFactory.getLogger(RequestCallbacks.class);
    public static final int MESSAGE_CODE = 257;

    public int getMessageCode() {
        return 257;
    }

    public Class<?> getMessageClass() {
        return org.eclipse.scada.core.data.message.RequestCallbacks.class;
    }

    public org.eclipse.scada.core.data.message.RequestCallbacks decodeMessage(BinaryContext _context, IoBuffer _data) throws Exception {
        int messageCode = _data.getInt();
        if (messageCode != 257) {
            throw new IllegalStateException(String.format("Expected messageCode %s but found %s", 257, messageCode));
        }
        int numberOfFields = _data.get();
        Request request = null;
        long callbackHandlerId = 0L;
        List<CallbackRequest> callbacks = null;
        Long timeoutMillis = null;
        logger.trace("Decoding {} fields", (Object)((byte)numberOfFields));
        int i = 0;
        while (i < numberOfFields) {
            byte fieldNumber = _data.get();
            switch (fieldNumber) {
                case 1: {
                    request = Structures.decodeRequest(_context, _data, false);
                    break;
                }
                case 2: {
                    callbackHandlerId = _context.decodePrimitiveLong(_data);
                    break;
                }
                case 3: {
                    callbacks = Structures.decodeListCallbackRequest(_context, _data, true);
                    break;
                }
                case 4: {
                    timeoutMillis = _context.decodeLong(_data);
                    break;
                }
                default: {
                    logger.warn("Received unknown field number: {}", (Object)fieldNumber);
                }
            }
            ++i;
        }
        return new org.eclipse.scada.core.data.message.RequestCallbacks(request, callbackHandlerId, callbacks, timeoutMillis);
    }

    public IoBuffer encodeMessage(BinaryContext context, Object objectMessage) throws Exception {
        org.eclipse.scada.core.data.message.RequestCallbacks value = (org.eclipse.scada.core.data.message.RequestCallbacks)objectMessage;
        IoBuffer data = IoBuffer.allocate((int)64);
        data.setAutoExpand(true);
        data.putInt(257);
        data.put((byte)4);
        Structures.encodeRequest(context, data, (byte)1, value.getRequest());
        context.encodePrimitiveLong(data, (byte)2, value.getCallbackHandlerId());
        Structures.encodeCollectionCallbackRequest(context, data, (byte)3, value.getCallbacks());
        context.encodeLong(data, (byte)4, value.getTimeoutMillis());
        data.flip();
        return data;
    }
}

