/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.connection.provider;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.scada.core.client.AutoReconnectController;
import org.eclipse.scada.core.client.Connection;
import org.eclipse.scada.core.connection.provider.ConnectionService;
import org.eclipse.scada.core.connection.provider.info.ConnectionInformationProvider;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.utils.stats.StatisticEntry;
import org.eclipse.scada.utils.stats.StatisticsImpl;
import org.eclipse.scada.utils.stats.StatisticsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnectionService
implements ConnectionService,
ConnectionInformationProvider {
    private static final Logger logger = LoggerFactory.getLogger(AbstractConnectionService.class);
    private Connection connection;
    private AutoReconnectController controller;
    protected final StatisticsImpl statistics = new StatisticsImpl();
    private final boolean lazyActivation;
    private boolean connectionRequested = false;
    private final Integer autoReconnectDelay;
    private CallbackHandler connectCallbackHandler;

    public AbstractConnectionService(Integer autoReconnectDelay, boolean lazyActivation) {
        this.lazyActivation = lazyActivation;
        this.autoReconnectDelay = autoReconnectDelay;
    }

    @Override
    public void setConnectCallbackHandler(CallbackHandler callbackHandler) {
        this.connectCallbackHandler = callbackHandler;
    }

    protected void setConnection(Connection connection) {
        this.connection = connection;
        this.controller = this.autoReconnectDelay != null ? new AutoReconnectController(connection, (long)this.autoReconnectDelay.intValue()) : null;
    }

    @Override
    public void dispose() {
        logger.info("Disposing: {}", (Object)this.connection);
        this.disconnect();
        if (this.controller != null) {
            this.controller.dispose();
        }
        if (this.connection != null) {
            this.connection.dispose();
        }
    }

    @Override
    public AutoReconnectController getAutoReconnectController() {
        return this.controller;
    }

    protected boolean shouldConnect() {
        return true;
    }

    protected synchronized void checkConnect() {
        if (this.connectionRequested && (!this.lazyActivation || this.shouldConnect())) {
            this.performConnect();
        } else {
            this.performDisconnect();
        }
    }

    @Override
    public synchronized void connect() {
        this.connectionRequested = true;
        this.checkConnect();
    }

    protected void performConnect() {
        if (this.controller != null) {
            this.controller.connect(this.connectCallbackHandler);
        } else {
            this.connection.connect(this.connectCallbackHandler);
        }
    }

    @Override
    public synchronized void disconnect() {
        this.connectionRequested = false;
        this.checkConnect();
    }

    protected void performDisconnect() {
        if (this.controller != null) {
            this.controller.disconnect();
        } else {
            this.connection.disconnect();
        }
    }

    @Override
    public String getLabel() {
        return this.connection.getConnectionInformation().toMaskedString();
    }

    @Override
    public Collection<StatisticEntry> getStatistics() {
        ArrayList<StatisticEntry> result = new ArrayList<StatisticEntry>();
        result.addAll(this.statistics.getEntries());
        if (this.connection instanceof StatisticsProvider) {
            result.addAll(((StatisticsProvider)this.connection).getStatistics());
        }
        if (this.controller instanceof StatisticsProvider) {
            result.addAll(((StatisticsProvider)this.controller).getStatistics());
        }
        return result;
    }
}

