/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.connection.login.factory;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.connection.provider.ConnectionService;
import org.eclipse.scada.core.ui.connection.creator.ConnectionCreatorHelper;
import org.eclipse.scada.core.ui.connection.login.LoginContext;
import org.eclipse.scada.core.ui.connection.login.LoginFactory;
import org.eclipse.scada.core.ui.connection.login.LoginHandler;
import org.eclipse.scada.core.ui.connection.login.factory.MultiLoginHandler;
import org.eclipse.scada.core.ui.connection.login.factory.internal.ConnectionLoginHandler;
import org.eclipse.scada.core.ui.connection.login.factory.internal.LoginConnection;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.sec.callback.PropertiesCredentialsCallback;

public class ConnectionLoginFactory
implements LoginFactory {
    public static final String OPTION_CREDENTIALS_AS_PROPERTIES = "credentialsAsProperties";

    @Override
    public LoginHandler createHandler(LoginContext context, String username, String password, Map<String, String> properties) throws Exception {
        LinkedList<LoginHandler> handlers = new LinkedList<LoginHandler>();
        for (LoginConnection loginConnection : this.loadConnections(context.getId())) {
            PropertiesCredentialsCallback callbackHandler;
            ConnectionInformation ci = loginConnection.getConnectionInformation();
            if (!loginConnection.isUseCallbacks() || properties.containsKey(OPTION_CREDENTIALS_AS_PROPERTIES)) {
                ci.setUser(username);
                ci.setPassword(password);
                callbackHandler = null;
            } else {
                callbackHandler = new PropertiesCredentialsCallback(username, password);
            }
            ConnectionService connectionService = ConnectionCreatorHelper.createConnection((ConnectionInformation)ci, (Integer)loginConnection.getAutoReconnectDelay(), (loginConnection.getMode() == LoginConnection.Mode.LAZY ? 1 : 0) != 0);
            if (connectionService == null) {
                this.disposeAll(handlers);
                throw new IllegalStateException(String.format("Unable to find connection creator for connection %s", loginConnection.getConnectionInformation().toMaskedString()));
            }
            handlers.add(new ConnectionLoginHandler(connectionService, loginConnection, (CallbackHandler)callbackHandler));
        }
        return new MultiLoginHandler(handlers);
    }

    protected Set<LoginConnection> loadConnections(String contextId) {
        HashSet<LoginConnection> result = new HashSet<LoginConnection>();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.scada.core.ui.connection.login.context");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ele = iConfigurationElementArray[n2];
            if ("context".equals(ele.getName()) && contextId.equals(ele.getAttribute("id"))) {
                IConfigurationElement[] iConfigurationElementArray2 = ele.getChildren("connection");
                int n3 = iConfigurationElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement child = iConfigurationElementArray2[n4];
                    ConnectionInformation ci = ConnectionInformation.fromURI((String)child.getAttribute("uri"));
                    if (ci == null) {
                        throw new IllegalArgumentException(String.format("Unable to parse connection uri: %s", child.getAttribute("uri")));
                    }
                    HashSet<String> servicePids = new HashSet<String>();
                    String modeString = child.getAttribute("mode");
                    LoginConnection.Mode mode = modeString == null ? LoginConnection.Mode.NORMAL : LoginConnection.Mode.valueOf(modeString);
                    this.addServicePid(servicePids, child.getAttribute("servicePid"));
                    IConfigurationElement[] iConfigurationElementArray3 = child.getChildren("registration");
                    int n5 = iConfigurationElementArray3.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IConfigurationElement registrationElement = iConfigurationElementArray3[n6];
                        this.addServicePid(servicePids, registrationElement.getAttribute("servicePid"));
                        ++n6;
                    }
                    Integer servicePriority = child.getAttribute("servicePriority") != null ? Integer.valueOf(Integer.parseInt(child.getAttribute("servicePriority"))) : null;
                    Integer autoReconnectDelay = child.getAttribute("autoReconnectDelay") != null ? Integer.valueOf(Integer.parseInt(child.getAttribute("autoReconnectDelay"))) : null;
                    boolean useCallbacks = Boolean.parseBoolean(child.getAttribute("authUseCallbacks"));
                    LoginConnection lc = new LoginConnection(ci, servicePids, autoReconnectDelay, servicePriority, mode, useCallbacks);
                    result.add(lc);
                    ++n4;
                }
            }
            ++n2;
        }
        return result;
    }

    private void addServicePid(Set<String> servicePids, String attribute) {
        if (attribute != null && !attribute.isEmpty()) {
            servicePids.add(attribute);
        }
    }

    private void disposeAll(Collection<LoginHandler> handler) {
        for (LoginHandler service : handler) {
            service.dispose();
        }
        handler.clear();
    }
}

