/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.ui.styles;

import java.util.EnumSet;
import java.util.Set;
import org.eclipse.scada.core.ui.styles.AbstractStateInformation;
import org.eclipse.scada.core.ui.styles.StateInformation;
import org.eclipse.scada.da.client.DataItemValue;

public class DataItemValueStateExtractor
extends AbstractStateInformation {
    public DataItemValueStateExtractor(DataItemValue itemValue) {
        super(DataItemValueStateExtractor.extractStates(itemValue));
    }

    private static Set<StateInformation.State> extractStates(DataItemValue value) {
        if (value == null) {
            return EnumSet.noneOf(StateInformation.State.class);
        }
        EnumSet<StateInformation.State> result = EnumSet.noneOf(StateInformation.State.class);
        if (value.isError()) {
            result.add(StateInformation.State.ERROR);
        }
        if (value.isAlarm()) {
            result.add(StateInformation.State.ALARM);
        }
        if (value.isWarning()) {
            result.add(StateInformation.State.WARNING);
        }
        if (value.isBlocked()) {
            result.add(StateInformation.State.BLOCK);
        }
        if (value.isManual()) {
            result.add(StateInformation.State.MANUAL);
        }
        if (!value.isConnected()) {
            result.add(StateInformation.State.DISCONNECTED);
        }
        if (value.isAttribute("warning.ackRequired", false)) {
            result.add(StateInformation.State.WARNING_ACK);
        }
        if (value.isAttribute("alarm.ackRequired", false)) {
            result.add(StateInformation.State.ALARM_ACK);
        }
        if (value.isAttribute("error.ackRequired", false)) {
            result.add(StateInformation.State.ERROR_ACK);
        }
        return result;
    }
}

