/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec;

import org.eclipse.scada.sec.AuthorizationResult;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.sec.authz.AuthorizationContext;
import org.eclipse.scada.utils.lang.Immutable;

@Immutable
public class AuthorizationReply {
    private final AuthorizationResult result;
    private final AuthorizationContext context;

    public AuthorizationReply(AuthorizationResult result, AuthorizationContext context) {
        if (result == null) {
            throw new IllegalArgumentException("'result' must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("'context' must not be null");
        }
        this.result = result;
        this.context = context;
    }

    public boolean isGranted() {
        return this.result.isGranted();
    }

    public AuthorizationResult getResult() {
        return this.result;
    }

    public AuthorizationContext getContext() {
        return this.context;
    }

    public UserInformation getUserInformation() {
        return this.context.getRequest().getUserInformation();
    }

    public String toString() {
        return String.format("[AuthorizationReply - result: %s, request: %s]", this.result, this.context.getRequest());
    }

    public static AuthorizationReply createGranted(AuthorizationContext context) {
        return new AuthorizationReply(AuthorizationResult.GRANTED, context);
    }

    public static AuthorizationReply create(AuthorizationResult result, AuthorizationContext context) {
        return new AuthorizationReply(result, context);
    }
}

