/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.authn;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.scada.sec.AuthenticationException;
import org.eclipse.scada.sec.AuthenticationService;
import org.eclipse.scada.sec.StatusCodes;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.sec.authn.CredentialsRequest;
import org.eclipse.scada.sec.utils.password.PasswordType;
import org.eclipse.scada.utils.lang.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPlainAuthenticationService
implements AuthenticationService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPlainAuthenticationService.class);

    protected abstract UserEntry getUserEntry(String var1) throws Exception;

    @Override
    public UserInformation getUser(String user) {
        UserEntry entry;
        block3: {
            try {
                entry = this.getUserEntry(user);
                if (entry != null) break block3;
                return null;
            }
            catch (Exception e) {
                logger.debug("Failed to look up user - " + user, (Throwable)e);
                return null;
            }
        }
        return this.makeInfo(user, entry);
    }

    @Override
    public UserInformation authenticate(CredentialsRequest credentialsRequest) throws AuthenticationException {
        UserEntry user;
        String username = credentialsRequest.getUserName();
        logger.debug("Authenticating user: '{}'", (Object)username);
        try {
            user = this.getUserEntry(username);
        }
        catch (Exception e) {
            throw new AuthenticationException(StatusCodes.UNKNOWN_STATUS_CODE, "Failed to retrieve user data for user " + username, e);
        }
        if (user == null) {
            return null;
        }
        if (user.getPassword() == null) {
            return null;
        }
        try {
            if (PasswordType.PLAIN.createValdiator().validatePassword(credentialsRequest.getPasswords(), user.getPassword())) {
                return this.makeInfo(username, user);
            }
        }
        catch (Exception e) {
            logger.warn("Failed to authenticate", (Throwable)e);
            throw new AuthenticationException(StatusCodes.AUTHENTICATION_FAILED, e);
        }
        return null;
    }

    @Override
    public void joinRequest(CredentialsRequest request) {
        request.askUsername();
        request.askPassword(PasswordType.PLAIN.getSupportedInputEncodings());
    }

    protected UserInformation makeInfo(String name, UserEntry user) {
        return new UserInformation(name, user.getRoles());
    }

    @Immutable
    public static class UserEntry
    implements Serializable {
        private static final long serialVersionUID = -6899786759766310861L;
        private final String password;
        private final Set<String> roles;

        public UserEntry(String password, Collection<String> roles) {
            this.password = password;
            this.roles = new HashSet<String>(roles);
        }

        public String getPassword() {
            return this.password;
        }

        public Set<String> getRoles() {
            return Collections.unmodifiableSet(this.roles);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
            result = 31 * result + (this.roles == null ? 0 : this.roles.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UserEntry other = (UserEntry)obj;
            if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
                return false;
            }
            return !(this.roles == null ? other.roles != null : !this.roles.equals(other.roles));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("UserEntry [password=");
            sb.append(this.password == null ? "null" : "***");
            sb.append(", roles=");
            for (String role : this.roles) {
                sb.append(",");
                sb.append(role);
            }
            sb.append("]");
            return sb.toString();
        }
    }
}

