/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.callback;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.sec.callback.Callback;

public abstract class AbstractCallback
implements Callback {
    private boolean canceled;
    private int order;

    public AbstractCallback() {
    }

    public AbstractCallback(int order) {
        this.order = order;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public Map<String, String> buildRequestAttributes() {
        HashMap<String, String> result = new HashMap<String, String>();
        this.injectRequestAttributes(result);
        return result;
    }

    @Override
    public Map<String, String> buildResponseAttributes() {
        if (this.isCanceled()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        this.injectResponseAttributes(result);
        return result;
    }

    protected void injectRequestAttributes(Map<String, String> request) {
        request.put("order", Integer.valueOf(this.order).toString());
    }

    protected void injectResponseAttributes(Map<String, String> response) {
    }

    @Override
    public void parseRequestAttributes(Map<String, String> attributes) {
        this.order = this.parseInteger(attributes, "order", null);
    }

    @Override
    public void parseResponseAttributes(Map<String, String> attributes) {
    }

    protected Integer parseInteger(Map<String, String> attributes, String key, Integer defaultValue) {
        String value = attributes.get(key);
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }
}

