/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.callback;

import org.eclipse.scada.sec.callback.Callback;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.utils.concurrent.InstantFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Callbacks {
    private static final Logger logger = LoggerFactory.getLogger(Callbacks.class);

    private Callbacks() {
    }

    public static NotifyFuture<Callback[]> callback(CallbackHandler callbackHandler, Callback[] callbacks) {
        if (callbacks == null) {
            return new InstantFuture((Object)callbacks);
        }
        if (callbackHandler == null) {
            Callback[] callbackArray = callbacks;
            int n = callbacks.length;
            int n2 = 0;
            while (n2 < n) {
                Callback callback = callbackArray[n2];
                logger.debug("Cancelling callback: {}", (Object)callback);
                if (callback != null) {
                    callback.cancel();
                }
                ++n2;
            }
            return new InstantFuture((Object)callbacks);
        }
        return callbackHandler.performCallback(callbacks);
    }

    public static NotifyFuture<Callback[]> callback(CallbackHandler callbackHandler, Callback callback) {
        return Callbacks.callback(callbackHandler, new Callback[]{callback});
    }

    public static NotifyFuture<Callback[]> cancelAll(Callback[] callbacks) {
        if (callbacks == null) {
            return new InstantFuture((Object)callbacks);
        }
        Callback[] callbackArray = callbacks;
        int n = callbacks.length;
        int n2 = 0;
        while (n2 < n) {
            Callback callback = callbackArray[n2];
            logger.debug("Cancelling callback: {}", (Object)callback);
            callback.cancel();
            ++n2;
        }
        return new InstantFuture((Object)callbacks);
    }
}

