/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.callback;

import java.util.Map;
import org.eclipse.scada.sec.callback.Callback;
import org.eclipse.scada.sec.callback.CallbackFactory;
import org.eclipse.scada.sec.callback.ConfirmationCallback;
import org.eclipse.scada.sec.callback.PasswordCallback;
import org.eclipse.scada.sec.callback.TextCallback;
import org.eclipse.scada.sec.callback.UserNameCallback;
import org.eclipse.scada.sec.callback.XMLSignatureCallback;

public class DefaultCallbackFactory
implements CallbackFactory {
    @Override
    public Callback createCallback(String type, Map<String, String> attributes) {
        if ("username".equals(type)) {
            return this.applyAttributes(new UserNameCallback(), attributes);
        }
        if ("text".equals(type)) {
            return this.applyAttributes(new TextCallback(), attributes);
        }
        if ("password".equals(type)) {
            return this.applyAttributes(new PasswordCallback(), attributes);
        }
        if ("confirm".equals(type)) {
            return this.applyAttributes(new ConfirmationCallback(), attributes);
        }
        if ("xmlsignature".equals(type)) {
            return this.applyAttributes(new XMLSignatureCallback(), attributes);
        }
        return null;
    }

    private Callback applyAttributes(Callback callback, Map<String, String> attributes) {
        if (callback != null) {
            callback.parseRequestAttributes(attributes);
        }
        return callback;
    }
}

