/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.net;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.compression.CompressionFilter;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.filter.ssl.SslFilter;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.net.mina.GMPPProtocolDecoder;
import org.eclipse.scada.net.mina.GMPPProtocolEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionHelper {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionHelper.class);

    public static void injectCompression(IoSession session, String compressionMode) {
        logger.debug("Prepare for compression filter injection: {}", (Object)compressionMode);
        CompressionFilter compressionFilter = ConnectionHelper.createCompressionFilter(compressionMode);
        if (compressionFilter == null) {
            return;
        }
        if (!session.getFilterChain().contains("compress")) {
            logger.debug("Injecting compression filter: {}", (Object)compressionFilter);
            session.getFilterChain().addFirst("compress", (IoFilter)compressionFilter);
        }
    }

    private static CompressionFilter createCompressionFilter(String compressionMode) {
        if (compressionMode != null) {
            logger.debug("Compression mode {}", (Object)compressionMode);
            int level = -1;
            try {
                level = Integer.parseInt(compressionMode);
            }
            catch (Exception e) {
                logger.warn("Failed to parse 'compress' property", (Throwable)e);
            }
            if (level < -1 || level > 9) {
                logger.warn("Compression ({}) outside of valid range. Setting to default", (Object)level);
                level = -1;
            }
            logger.debug("Creating filter with compression mode: {}", (Object)level);
            return new CompressionFilter(level);
        }
        return null;
    }

    public static void setupFilterChain(ConnectionInformation connectionInformation, DefaultIoFilterChainBuilder filterChainBuilder, boolean isClient) {
        String trace;
        String ssl;
        CompressionFilter compressionFilter = ConnectionHelper.createCompressionFilter((String)connectionInformation.getProperties().get("compress"));
        if (compressionFilter != null) {
            filterChainBuilder.addLast("compress", (IoFilter)compressionFilter);
        }
        if ((ssl = (String)connectionInformation.getProperties().get("ssl")) != null) {
            ConnectionHelper.initSsl(connectionInformation, filterChainBuilder, isClient);
        }
        if ((trace = (String)connectionInformation.getProperties().get("trace")) != null) {
            filterChainBuilder.addLast("logging", (IoFilter)new LoggingFilter());
        }
        filterChainBuilder.addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolEncoder)new GMPPProtocolEncoder(), (ProtocolDecoder)new GMPPProtocolDecoder()));
    }

    protected static void initSsl(ConnectionInformation connectionInformation, DefaultIoFilterChainBuilder filterChainBuilder, boolean isClient) {
        SSLContext sslContext = null;
        try {
            sslContext = ConnectionHelper.createContext(connectionInformation);
            sslContext.init(ConnectionHelper.getKeyManagers(connectionInformation, isClient), ConnectionHelper.getTrustManagers(connectionInformation), ConnectionHelper.getRandom(connectionInformation));
        }
        catch (Throwable e) {
            logger.warn("Failed to enable SSL", e);
        }
        if (sslContext != null) {
            SslFilter filter = new SslFilter(sslContext);
            filter.setUseClientMode(isClient);
            filterChainBuilder.addFirst("sslFilter", (IoFilter)filter);
        }
    }

    private static SSLContext createContext(ConnectionInformation connectionInformation) throws NoSuchAlgorithmException {
        String sslProtocol = (String)connectionInformation.getProperties().get("sslProtocol");
        if (sslProtocol == null || sslProtocol.length() == 0) {
            sslProtocol = "SSLv3";
        }
        return SSLContext.getInstance(sslProtocol);
    }

    private static SecureRandom getRandom(ConnectionInformation connectionInformation) throws NoSuchAlgorithmException {
        String sslRandom = (String)connectionInformation.getProperties().get("sslRandom");
        SecureRandom random = null;
        if (sslRandom != null && sslRandom.length() > 0) {
            random = SecureRandom.getInstance(sslRandom);
            return random;
        }
        return null;
    }

    private static TrustManager[] getTrustManagers(ConnectionInformation connectionInformation) {
        return new TrustManager[]{new X509TrustManagerImplementation()};
    }

    private static KeyManager[] getKeyManagers(ConnectionInformation connectionInformation, boolean isClient) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, CertificateException, IOException {
        if (isClient) {
            return null;
        }
        KeyStore keyStore = ConnectionHelper.createKeyStore(connectionInformation);
        String keyManagerFactory = KeyManagerFactory.getDefaultAlgorithm();
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(keyManagerFactory);
        kmf.init(keyStore, ConnectionHelper.getPassword(connectionInformation, "sslCertPassword"));
        return kmf.getKeyManagers();
    }

    private static KeyStore createKeyStore(ConnectionInformation connectionInformation) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        String keyStoreType = (String)connectionInformation.getProperties().get("sslKeyStoreType");
        KeyStore keyStore = keyStoreType != null ? KeyStore.getInstance(keyStoreType) : KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(ConnectionHelper.getKeyStoreStream(connectionInformation), ConnectionHelper.getPassword(connectionInformation, "sslKeyStorePassword"));
        return keyStore;
    }

    private static InputStream getKeyStoreStream(ConnectionInformation connectionInformation) throws IOException {
        String uri = (String)connectionInformation.getProperties().get("sslKeyStoreUri");
        URL url = new URL(uri);
        return url.openStream();
    }

    private static char[] getPassword(ConnectionInformation connectionInformation, String propertyName) {
        String password = (String)connectionInformation.getProperties().get(propertyName);
        char[] passwordChars = password != null ? password.toCharArray() : null;
        return passwordChars;
    }

    private static final class X509TrustManagerImplementation
    implements X509TrustManager {
        private X509TrustManagerImplementation() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            logger.info("checkClientTrusted: " + arg0 + "/" + arg1);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            logger.info("checkServerTrusted: " + arg0 + "/" + arg1);
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            logger.info("getAcceptedIssuers");
            return new X509Certificate[0];
        }
    }
}

