/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.protocol.ngp.codec;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.ca.data.ConfigurationInformation;
import org.eclipse.scada.ca.data.ConfigurationState;
import org.eclipse.scada.ca.data.DiffEntry;
import org.eclipse.scada.ca.data.FactoryInformation;
import org.eclipse.scada.ca.data.FactoryState;
import org.eclipse.scada.ca.data.Operation;
import org.eclipse.scada.core.ngp.common.codec.osbp.BinaryContext;
import org.eclipse.scada.protocol.ngp.common.utils.ArrayListAllocator;
import org.eclipse.scada.protocol.ngp.common.utils.CollectionAllocator;
import org.eclipse.scada.protocol.ngp.common.utils.HashSetAllocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Structures {
    private static final Logger logger = LoggerFactory.getLogger(Structures.class);
    private static final ArrayListAllocator<FactoryInformation> ALLOC_FACTORYINFORMATION_LIST = new ArrayListAllocator();
    private static final HashSetAllocator<FactoryInformation> ALLOC_FACTORYINFORMATION_SET = new HashSetAllocator();
    private static final ArrayListAllocator<ConfigurationInformation> ALLOC_CONFIGURATIONINFORMATION_LIST = new ArrayListAllocator();
    private static final HashSetAllocator<ConfigurationInformation> ALLOC_CONFIGURATIONINFORMATION_SET = new HashSetAllocator();
    private static final ArrayListAllocator<DiffEntry> ALLOC_DIFFENTRY_LIST = new ArrayListAllocator();
    private static final HashSetAllocator<DiffEntry> ALLOC_DIFFENTRY_SET = new HashSetAllocator();

    private Structures() {
    }

    protected static void inlineEncodeFactoryInformation(BinaryContext context, IoBuffer data, FactoryInformation value) throws Exception {
        data.put((byte)4);
        context.encodeString(data, (byte)1, value.getId());
        context.encodeString(data, (byte)2, value.getDescription());
        context.encodeEnum(data, (byte)3, (Enum)value.getState());
        Structures.encodeCollectionConfigurationInformation(context, data, (byte)4, value.getConfigurations());
    }

    protected static FactoryInformation inlindeDecodeFactoryInformation(BinaryContext _context, IoBuffer _data) throws Exception {
        int numberOfFields = _data.get();
        String id = null;
        String description = null;
        FactoryState state = null;
        List<ConfigurationInformation> configurations = null;
        logger.trace("Decoding {} fields", (Object)((byte)numberOfFields));
        int i = 0;
        while (i < numberOfFields) {
            byte fieldNumber = _data.get();
            switch (fieldNumber) {
                case 1: {
                    id = _context.decodeString(_data);
                    break;
                }
                case 2: {
                    description = _context.decodeString(_data);
                    break;
                }
                case 3: {
                    state = (FactoryState)_context.decodeEnum(_data, FactoryState.class);
                    break;
                }
                case 4: {
                    configurations = Structures.decodeListConfigurationInformation(_context, _data, true);
                    break;
                }
                default: {
                    logger.warn("Received unknown field number: {}", (Object)fieldNumber);
                }
            }
            ++i;
        }
        return new FactoryInformation(id, description, state, configurations);
    }

    public static void encodeFactoryInformation(BinaryContext context, IoBuffer data, byte fieldNumber, FactoryInformation value) throws Exception {
        context.beginWriteStructure(data, fieldNumber, value == null);
        if (value != null) {
            Structures.inlineEncodeFactoryInformation(context, data, value);
        }
    }

    public static void encodeCollectionFactoryInformation(BinaryContext context, IoBuffer data, byte fieldNumber, Collection<FactoryInformation> values) throws Exception {
        context.beginWriteStructureList(data, fieldNumber, values);
        if (values == null) {
            return;
        }
        for (FactoryInformation entry : values) {
            Structures.inlineEncodeFactoryInformation(context, data, entry);
        }
    }

    public static FactoryInformation decodeFactoryInformation(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        boolean isNull = context.beginReadStructure(data, allowNull);
        if (isNull) {
            return null;
        }
        return Structures.inlindeDecodeFactoryInformation(context, data);
    }

    protected static void fillFactoryInformationCollection(BinaryContext context, IoBuffer data, int items, Collection<FactoryInformation> values) throws Exception {
        int i = 0;
        while (i < items) {
            values.add(Structures.inlindeDecodeFactoryInformation(context, data));
            ++i;
        }
    }

    protected static <T extends Collection<FactoryInformation>> T decodeFactoryInformationCollection(BinaryContext context, IoBuffer data, CollectionAllocator<FactoryInformation, T> allactor, boolean allowNull) throws Exception {
        Integer len = context.beginReadStructureList(data, allowNull);
        if (len == null) {
            return null;
        }
        Collection result = allactor.allocate(len.intValue());
        Structures.fillFactoryInformationCollection(context, data, len, result);
        return (T)result;
    }

    public static List<FactoryInformation> decodeListFactoryInformation(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        return (List)Structures.decodeFactoryInformationCollection(context, data, ALLOC_FACTORYINFORMATION_LIST, allowNull);
    }

    public static Set<FactoryInformation> decodeSetFactoryInformation(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        return (Set)Structures.decodeFactoryInformationCollection(context, data, ALLOC_FACTORYINFORMATION_SET, allowNull);
    }

    protected static void inlineEncodeConfigurationInformation(BinaryContext context, IoBuffer data, ConfigurationInformation value) throws Exception {
        data.put((byte)5);
        context.encodeString(data, (byte)1, value.getFactoryId());
        context.encodeString(data, (byte)2, value.getId());
        context.encodeEnum(data, (byte)3, (Enum)value.getState());
        context.encodeProperties(data, (byte)4, value.getData());
        context.encodeString(data, (byte)5, value.getErrorInformation());
    }

    protected static ConfigurationInformation inlindeDecodeConfigurationInformation(BinaryContext _context, IoBuffer _data) throws Exception {
        int numberOfFields = _data.get();
        String factoryId = null;
        String id = null;
        ConfigurationState state = null;
        Map data = null;
        String errorInformation = null;
        logger.trace("Decoding {} fields", (Object)((byte)numberOfFields));
        int i = 0;
        while (i < numberOfFields) {
            byte fieldNumber = _data.get();
            switch (fieldNumber) {
                case 1: {
                    factoryId = _context.decodeString(_data);
                    break;
                }
                case 2: {
                    id = _context.decodeString(_data);
                    break;
                }
                case 3: {
                    state = (ConfigurationState)_context.decodeEnum(_data, ConfigurationState.class);
                    break;
                }
                case 4: {
                    data = _context.decodeProperties(_data);
                    break;
                }
                case 5: {
                    errorInformation = _context.decodeString(_data);
                    break;
                }
                default: {
                    logger.warn("Received unknown field number: {}", (Object)fieldNumber);
                }
            }
            ++i;
        }
        return new ConfigurationInformation(factoryId, id, state, data, errorInformation);
    }

    public static void encodeConfigurationInformation(BinaryContext context, IoBuffer data, byte fieldNumber, ConfigurationInformation value) throws Exception {
        context.beginWriteStructure(data, fieldNumber, value == null);
        if (value != null) {
            Structures.inlineEncodeConfigurationInformation(context, data, value);
        }
    }

    public static void encodeCollectionConfigurationInformation(BinaryContext context, IoBuffer data, byte fieldNumber, Collection<ConfigurationInformation> values) throws Exception {
        context.beginWriteStructureList(data, fieldNumber, values);
        if (values == null) {
            return;
        }
        for (ConfigurationInformation entry : values) {
            Structures.inlineEncodeConfigurationInformation(context, data, entry);
        }
    }

    public static ConfigurationInformation decodeConfigurationInformation(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        boolean isNull = context.beginReadStructure(data, allowNull);
        if (isNull) {
            return null;
        }
        return Structures.inlindeDecodeConfigurationInformation(context, data);
    }

    protected static void fillConfigurationInformationCollection(BinaryContext context, IoBuffer data, int items, Collection<ConfigurationInformation> values) throws Exception {
        int i = 0;
        while (i < items) {
            values.add(Structures.inlindeDecodeConfigurationInformation(context, data));
            ++i;
        }
    }

    protected static <T extends Collection<ConfigurationInformation>> T decodeConfigurationInformationCollection(BinaryContext context, IoBuffer data, CollectionAllocator<ConfigurationInformation, T> allactor, boolean allowNull) throws Exception {
        Integer len = context.beginReadStructureList(data, allowNull);
        if (len == null) {
            return null;
        }
        Collection result = allactor.allocate(len.intValue());
        Structures.fillConfigurationInformationCollection(context, data, len, result);
        return (T)result;
    }

    public static List<ConfigurationInformation> decodeListConfigurationInformation(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        return (List)Structures.decodeConfigurationInformationCollection(context, data, ALLOC_CONFIGURATIONINFORMATION_LIST, allowNull);
    }

    public static Set<ConfigurationInformation> decodeSetConfigurationInformation(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        return (Set)Structures.decodeConfigurationInformationCollection(context, data, ALLOC_CONFIGURATIONINFORMATION_SET, allowNull);
    }

    protected static void inlineEncodeDiffEntry(BinaryContext context, IoBuffer data, DiffEntry value) throws Exception {
        data.put((byte)5);
        context.encodeString(data, (byte)1, value.getFactoryId());
        context.encodeString(data, (byte)2, value.getConfigurationId());
        context.encodeEnum(data, (byte)3, (Enum)value.getOperation());
        context.encodeProperties(data, (byte)5, value.getAddedOrUpdatedData());
        context.encodeStringCollection(data, (byte)6, (Collection)value.getRemovedData());
    }

    protected static DiffEntry inlindeDecodeDiffEntry(BinaryContext _context, IoBuffer _data) throws Exception {
        int numberOfFields = _data.get();
        String factoryId = null;
        String configurationId = null;
        Operation operation = null;
        Map addedOrUpdatedData = null;
        Set removedData = null;
        logger.trace("Decoding {} fields", (Object)((byte)numberOfFields));
        int i = 0;
        while (i < numberOfFields) {
            byte fieldNumber = _data.get();
            switch (fieldNumber) {
                case 1: {
                    factoryId = _context.decodeString(_data);
                    break;
                }
                case 2: {
                    configurationId = _context.decodeString(_data);
                    break;
                }
                case 3: {
                    operation = (Operation)_context.decodeEnum(_data, Operation.class);
                    break;
                }
                case 5: {
                    addedOrUpdatedData = _context.decodeProperties(_data);
                    break;
                }
                case 6: {
                    removedData = _context.decodeStringSet(_data);
                    break;
                }
                default: {
                    logger.warn("Received unknown field number: {}", (Object)fieldNumber);
                }
            }
            ++i;
        }
        return new DiffEntry(factoryId, configurationId, operation, null, addedOrUpdatedData, removedData);
    }

    public static void encodeDiffEntry(BinaryContext context, IoBuffer data, byte fieldNumber, DiffEntry value) throws Exception {
        context.beginWriteStructure(data, fieldNumber, value == null);
        if (value != null) {
            Structures.inlineEncodeDiffEntry(context, data, value);
        }
    }

    public static void encodeCollectionDiffEntry(BinaryContext context, IoBuffer data, byte fieldNumber, Collection<DiffEntry> values) throws Exception {
        context.beginWriteStructureList(data, fieldNumber, values);
        if (values == null) {
            return;
        }
        for (DiffEntry entry : values) {
            Structures.inlineEncodeDiffEntry(context, data, entry);
        }
    }

    public static DiffEntry decodeDiffEntry(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        boolean isNull = context.beginReadStructure(data, allowNull);
        if (isNull) {
            return null;
        }
        return Structures.inlindeDecodeDiffEntry(context, data);
    }

    protected static void fillDiffEntryCollection(BinaryContext context, IoBuffer data, int items, Collection<DiffEntry> values) throws Exception {
        int i = 0;
        while (i < items) {
            values.add(Structures.inlindeDecodeDiffEntry(context, data));
            ++i;
        }
    }

    protected static <T extends Collection<DiffEntry>> T decodeDiffEntryCollection(BinaryContext context, IoBuffer data, CollectionAllocator<DiffEntry, T> allactor, boolean allowNull) throws Exception {
        Integer len = context.beginReadStructureList(data, allowNull);
        if (len == null) {
            return null;
        }
        Collection result = allactor.allocate(len.intValue());
        Structures.fillDiffEntryCollection(context, data, len, result);
        return (T)result;
    }

    public static List<DiffEntry> decodeListDiffEntry(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        return (List)Structures.decodeDiffEntryCollection(context, data, ALLOC_DIFFENTRY_LIST, allowNull);
    }

    public static Set<DiffEntry> decodeSetDiffEntry(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        return (Set)Structures.decodeDiffEntryCollection(context, data, ALLOC_DIFFENTRY_SET, allowNull);
    }
}

