/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.protocol.ngp.codec.impl;

import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.core.data.Request;
import org.eclipse.scada.core.ngp.common.codec.osbp.BinaryContext;
import org.eclipse.scada.core.ngp.common.codec.osbp.BinaryMessageCodec;
import org.eclipse.scada.core.protocol.ngp.codec.Structures;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetConfigurationRequest
implements BinaryMessageCodec {
    private static final Logger logger = LoggerFactory.getLogger(GetConfigurationRequest.class);
    public static final int MESSAGE_CODE = 16389;

    public int getMessageCode() {
        return 16389;
    }

    public Class<?> getMessageClass() {
        return org.eclipse.scada.ca.data.message.GetConfigurationRequest.class;
    }

    public org.eclipse.scada.ca.data.message.GetConfigurationRequest decodeMessage(BinaryContext _context, IoBuffer _data) throws Exception {
        int messageCode = _data.getInt();
        if (messageCode != 16389) {
            throw new IllegalStateException(String.format("Expected messageCode %s but found %s", 16389, messageCode));
        }
        int numberOfFields = _data.get();
        Request request = null;
        String factoryId = null;
        String configurationId = null;
        logger.trace("Decoding {} fields", (Object)((byte)numberOfFields));
        int i = 0;
        while (i < numberOfFields) {
            byte fieldNumber = _data.get();
            switch (fieldNumber) {
                case 1: {
                    request = Structures.decodeRequest((BinaryContext)_context, (IoBuffer)_data, (boolean)false);
                    break;
                }
                case 2: {
                    factoryId = _context.decodeString(_data);
                    break;
                }
                case 3: {
                    configurationId = _context.decodeString(_data);
                    break;
                }
                default: {
                    logger.warn("Received unknown field number: {}", (Object)fieldNumber);
                }
            }
            ++i;
        }
        return new org.eclipse.scada.ca.data.message.GetConfigurationRequest(request, factoryId, configurationId);
    }

    public IoBuffer encodeMessage(BinaryContext context, Object objectMessage) throws Exception {
        org.eclipse.scada.ca.data.message.GetConfigurationRequest value = (org.eclipse.scada.ca.data.message.GetConfigurationRequest)objectMessage;
        IoBuffer data = IoBuffer.allocate((int)64);
        data.setAutoExpand(true);
        data.putInt(16389);
        data.put((byte)3);
        Structures.encodeRequest((BinaryContext)context, (IoBuffer)data, (byte)1, (Request)value.getRequest());
        context.encodeString(data, (byte)2, value.getFactoryId());
        context.encodeString(data, (byte)3, value.getConfigurationId());
        data.flip();
        return data;
    }
}

