/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ngp;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.scada.core.OperationException;
import org.eclipse.scada.core.data.Request;
import org.eclipse.scada.core.data.RequestMessage;
import org.eclipse.scada.core.data.ResponseMessage;
import org.eclipse.scada.core.ngp.MessageSender;
import org.eclipse.scada.utils.concurrent.ExecutorFuture;
import org.eclipse.scada.utils.concurrent.InstantErrorFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.eclipse.scada.utils.stats.StatisticsImpl;

public class ResponseManager {
    private static final Object STATS_OPEN_REQUESTS = new Object();
    private final Map<Long, ExecutorFuture<ResponseMessage>> requestMap = new HashMap<Long, ExecutorFuture<ResponseMessage>>();
    private final StatisticsImpl statistics;
    private boolean connected;
    private final MessageSender messageSender;
    private final Executor executor;
    private final AtomicLong sequenceNumber = new AtomicLong();

    public ResponseManager(StatisticsImpl statistics, MessageSender messageSender, Executor executor) {
        this.statistics = statistics;
        this.messageSender = messageSender;
        this.executor = executor;
        this.statistics.setLabel(STATS_OPEN_REQUESTS, "Open requests");
    }

    public void handleResponse(ResponseMessage message) {
        ExecutorFuture<ResponseMessage> request = this.requestMap.remove(message.getResponse().getRequest().getRequestId());
        if (request != null) {
            this.statistics.setCurrentValue(STATS_OPEN_REQUESTS, (double)this.requestMap.size());
            request.asyncSetResult((Object)message);
        }
    }

    public void connected() {
        this.connected = true;
    }

    public void disconnected() {
        this.connected = false;
        for (ExecutorFuture<ResponseMessage> request : this.requestMap.values()) {
            request.asyncSetError((Throwable)new OperationException("Operation was cancelled"));
        }
        this.requestMap.clear();
    }

    public NotifyFuture<ResponseMessage> sendRequestMessage(RequestMessage requestMessage) {
        Request request = requestMessage.getRequest();
        if (request == null) {
            return null;
        }
        if (!this.connected) {
            return new InstantErrorFuture((Throwable)new IllegalStateException("Connection is not conected"));
        }
        this.messageSender.sendMessage(requestMessage);
        long requestId = request.getRequestId();
        ExecutorFuture result = new ExecutorFuture(this.executor);
        this.requestMap.put(requestId, (ExecutorFuture<ResponseMessage>)result);
        this.statistics.setCurrentValue(STATS_OPEN_REQUESTS, (double)this.requestMap.size());
        return result;
    }

    public Request nextRequest() {
        return new Request(this.sequenceNumber.incrementAndGet());
    }
}

