/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.server;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.core.data.UserInformation;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.utils.lang.Immutable;

@Immutable
public class OperationParameters {
    private final org.eclipse.scada.sec.UserInformation userInformation;
    private final Map<String, String> properties;
    private final CallbackHandler callbackHandler;

    public OperationParameters(org.eclipse.scada.sec.UserInformation userInformation, Map<String, String> properties, CallbackHandler callbackHandler) {
        this.userInformation = userInformation;
        this.properties = properties == null ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap<String, String>(properties));
        this.callbackHandler = callbackHandler;
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public org.eclipse.scada.sec.UserInformation getUserInformation() {
        return this.userInformation;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String toString() {
        return String.format("[OperationParameters - userInformation: %s, properties: %s, callbackHandler: %s]", this.userInformation, this.properties, this.callbackHandler);
    }

    public org.eclipse.scada.core.data.OperationParameters asData() {
        UserInformation ui = this.userInformation == null ? null : new UserInformation(this.userInformation.getName());
        return new org.eclipse.scada.core.data.OperationParameters(ui, this.properties);
    }
}

