/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.protocol.ngp.codec;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.core.ngp.common.codec.osbp.BinaryContext;
import org.eclipse.scada.hd.data.HistoricalItemInformation;
import org.eclipse.scada.hd.data.QueryParameters;
import org.eclipse.scada.hd.data.ValueEntry;
import org.eclipse.scada.hd.data.ValueInformation;
import org.eclipse.scada.protocol.ngp.common.utils.ArrayListAllocator;
import org.eclipse.scada.protocol.ngp.common.utils.CollectionAllocator;
import org.eclipse.scada.protocol.ngp.common.utils.HashSetAllocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Structures {
    private static final Logger logger = LoggerFactory.getLogger(Structures.class);
    private static final ArrayListAllocator<QueryParameters> ALLOC_QUERYPARAMETERS_LIST = new ArrayListAllocator();
    private static final HashSetAllocator<QueryParameters> ALLOC_QUERYPARAMETERS_SET = new HashSetAllocator();
    private static final ArrayListAllocator<HistoricalItemInformation> ALLOC_HISTORICALITEMINFORMATION_LIST = new ArrayListAllocator();
    private static final HashSetAllocator<HistoricalItemInformation> ALLOC_HISTORICALITEMINFORMATION_SET = new HashSetAllocator();
    private static final ArrayListAllocator<ValueInformation> ALLOC_VALUEINFORMATION_LIST = new ArrayListAllocator();
    private static final HashSetAllocator<ValueInformation> ALLOC_VALUEINFORMATION_SET = new HashSetAllocator();
    private static final ArrayListAllocator<ValueEntry> ALLOC_VALUEENTRY_LIST = new ArrayListAllocator();
    private static final HashSetAllocator<ValueEntry> ALLOC_VALUEENTRY_SET = new HashSetAllocator();

    private Structures() {
    }

    protected static void inlineEncodeQueryParameters(BinaryContext context, IoBuffer data, QueryParameters value) throws Exception {
        data.put((byte)3);
        context.encodePrimitiveLong(data, (byte)1, value.getStartTimestamp());
        context.encodePrimitiveLong(data, (byte)2, value.getEndTimestamp());
        context.encodePrimitiveInt(data, (byte)3, value.getNumberOfEntries());
    }

    protected static QueryParameters inlindeDecodeQueryParameters(BinaryContext _context, IoBuffer _data) throws Exception {
        int numberOfFields = _data.get();
        long startTimestamp = 0L;
        long endTimestamp = 0L;
        int numberOfEntries = 0;
        logger.trace("Decoding {} fields", (Object)((byte)numberOfFields));
        int i = 0;
        while (i < numberOfFields) {
            byte fieldNumber = _data.get();
            switch (fieldNumber) {
                case 1: {
                    startTimestamp = _context.decodePrimitiveLong(_data);
                    break;
                }
                case 2: {
                    endTimestamp = _context.decodePrimitiveLong(_data);
                    break;
                }
                case 3: {
                    numberOfEntries = _context.decodePrimitiveInt(_data);
                    break;
                }
                default: {
                    logger.warn("Received unknown field number: {}", (Object)fieldNumber);
                }
            }
            ++i;
        }
        return new QueryParameters(startTimestamp, endTimestamp, numberOfEntries);
    }

    public static void encodeQueryParameters(BinaryContext context, IoBuffer data, byte fieldNumber, QueryParameters value) throws Exception {
        context.beginWriteStructure(data, fieldNumber, value == null);
        if (value != null) {
            Structures.inlineEncodeQueryParameters(context, data, value);
        }
    }

    public static void encodeCollectionQueryParameters(BinaryContext context, IoBuffer data, byte fieldNumber, Collection<QueryParameters> values) throws Exception {
        context.beginWriteStructureList(data, fieldNumber, values);
        if (values == null) {
            return;
        }
        for (QueryParameters entry : values) {
            Structures.inlineEncodeQueryParameters(context, data, entry);
        }
    }

    public static QueryParameters decodeQueryParameters(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        boolean isNull = context.beginReadStructure(data, allowNull);
        if (isNull) {
            return null;
        }
        return Structures.inlindeDecodeQueryParameters(context, data);
    }

    protected static void fillQueryParametersCollection(BinaryContext context, IoBuffer data, int items, Collection<QueryParameters> values) throws Exception {
        int i = 0;
        while (i < items) {
            values.add(Structures.inlindeDecodeQueryParameters(context, data));
            ++i;
        }
    }

    protected static <T extends Collection<QueryParameters>> T decodeQueryParametersCollection(BinaryContext context, IoBuffer data, CollectionAllocator<QueryParameters, T> allactor, boolean allowNull) throws Exception {
        Integer len = context.beginReadStructureList(data, allowNull);
        if (len == null) {
            return null;
        }
        Collection result = allactor.allocate(len.intValue());
        Structures.fillQueryParametersCollection(context, data, len, result);
        return (T)result;
    }

    public static List<QueryParameters> decodeListQueryParameters(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        return (List)Structures.decodeQueryParametersCollection(context, data, ALLOC_QUERYPARAMETERS_LIST, allowNull);
    }

    public static Set<QueryParameters> decodeSetQueryParameters(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        return (Set)Structures.decodeQueryParametersCollection(context, data, ALLOC_QUERYPARAMETERS_SET, allowNull);
    }

    protected static void inlineEncodeHistoricalItemInformation(BinaryContext context, IoBuffer data, HistoricalItemInformation value) throws Exception {
        data.put((byte)2);
        context.encodeString(data, (byte)1, value.getItemId());
        context.encodeVariantMap(data, (byte)2, value.getAttributes());
    }

    protected static HistoricalItemInformation inlindeDecodeHistoricalItemInformation(BinaryContext _context, IoBuffer _data) throws Exception {
        int numberOfFields = _data.get();
        String itemId = null;
        Map attributes = null;
        logger.trace("Decoding {} fields", (Object)((byte)numberOfFields));
        int i = 0;
        while (i < numberOfFields) {
            byte fieldNumber = _data.get();
            switch (fieldNumber) {
                case 1: {
                    itemId = _context.decodeString(_data);
                    break;
                }
                case 2: {
                    attributes = _context.decodeVariantMap(_data);
                    break;
                }
                default: {
                    logger.warn("Received unknown field number: {}", (Object)fieldNumber);
                }
            }
            ++i;
        }
        return new HistoricalItemInformation(itemId, attributes);
    }

    public static void encodeHistoricalItemInformation(BinaryContext context, IoBuffer data, byte fieldNumber, HistoricalItemInformation value) throws Exception {
        context.beginWriteStructure(data, fieldNumber, value == null);
        if (value != null) {
            Structures.inlineEncodeHistoricalItemInformation(context, data, value);
        }
    }

    public static void encodeCollectionHistoricalItemInformation(BinaryContext context, IoBuffer data, byte fieldNumber, Collection<HistoricalItemInformation> values) throws Exception {
        context.beginWriteStructureList(data, fieldNumber, values);
        if (values == null) {
            return;
        }
        for (HistoricalItemInformation entry : values) {
            Structures.inlineEncodeHistoricalItemInformation(context, data, entry);
        }
    }

    public static HistoricalItemInformation decodeHistoricalItemInformation(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        boolean isNull = context.beginReadStructure(data, allowNull);
        if (isNull) {
            return null;
        }
        return Structures.inlindeDecodeHistoricalItemInformation(context, data);
    }

    protected static void fillHistoricalItemInformationCollection(BinaryContext context, IoBuffer data, int items, Collection<HistoricalItemInformation> values) throws Exception {
        int i = 0;
        while (i < items) {
            values.add(Structures.inlindeDecodeHistoricalItemInformation(context, data));
            ++i;
        }
    }

    protected static <T extends Collection<HistoricalItemInformation>> T decodeHistoricalItemInformationCollection(BinaryContext context, IoBuffer data, CollectionAllocator<HistoricalItemInformation, T> allactor, boolean allowNull) throws Exception {
        Integer len = context.beginReadStructureList(data, allowNull);
        if (len == null) {
            return null;
        }
        Collection result = allactor.allocate(len.intValue());
        Structures.fillHistoricalItemInformationCollection(context, data, len, result);
        return (T)result;
    }

    public static List<HistoricalItemInformation> decodeListHistoricalItemInformation(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        return (List)Structures.decodeHistoricalItemInformationCollection(context, data, ALLOC_HISTORICALITEMINFORMATION_LIST, allowNull);
    }

    public static Set<HistoricalItemInformation> decodeSetHistoricalItemInformation(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        return (Set)Structures.decodeHistoricalItemInformationCollection(context, data, ALLOC_HISTORICALITEMINFORMATION_SET, allowNull);
    }

    protected static void inlineEncodeValueInformation(BinaryContext context, IoBuffer data, ValueInformation value) throws Exception {
        data.put((byte)5);
        context.encodePrimitiveDouble(data, (byte)1, value.getQuality());
        context.encodePrimitiveDouble(data, (byte)2, value.getManualPercentage());
        context.encodePrimitiveLong(data, (byte)3, value.getStartTimestamp());
        context.encodePrimitiveLong(data, (byte)4, value.getEndTimestamp());
        context.encodePrimitiveLong(data, (byte)5, value.getSourceValues());
    }

    protected static ValueInformation inlindeDecodeValueInformation(BinaryContext _context, IoBuffer _data) throws Exception {
        int numberOfFields = _data.get();
        double quality = 0.0;
        double manualPercentage = 0.0;
        long startTimestamp = 0L;
        long endTimestamp = 0L;
        long sourceValues = 0L;
        logger.trace("Decoding {} fields", (Object)((byte)numberOfFields));
        int i = 0;
        while (i < numberOfFields) {
            byte fieldNumber = _data.get();
            switch (fieldNumber) {
                case 1: {
                    quality = _context.decodePrimitiveDouble(_data);
                    break;
                }
                case 2: {
                    manualPercentage = _context.decodePrimitiveDouble(_data);
                    break;
                }
                case 3: {
                    startTimestamp = _context.decodePrimitiveLong(_data);
                    break;
                }
                case 4: {
                    endTimestamp = _context.decodePrimitiveLong(_data);
                    break;
                }
                case 5: {
                    sourceValues = _context.decodePrimitiveLong(_data);
                    break;
                }
                default: {
                    logger.warn("Received unknown field number: {}", (Object)fieldNumber);
                }
            }
            ++i;
        }
        return new ValueInformation(quality, manualPercentage, startTimestamp, endTimestamp, sourceValues);
    }

    public static void encodeValueInformation(BinaryContext context, IoBuffer data, byte fieldNumber, ValueInformation value) throws Exception {
        context.beginWriteStructure(data, fieldNumber, value == null);
        if (value != null) {
            Structures.inlineEncodeValueInformation(context, data, value);
        }
    }

    public static void encodeCollectionValueInformation(BinaryContext context, IoBuffer data, byte fieldNumber, Collection<ValueInformation> values) throws Exception {
        context.beginWriteStructureList(data, fieldNumber, values);
        if (values == null) {
            return;
        }
        for (ValueInformation entry : values) {
            Structures.inlineEncodeValueInformation(context, data, entry);
        }
    }

    public static ValueInformation decodeValueInformation(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        boolean isNull = context.beginReadStructure(data, allowNull);
        if (isNull) {
            return null;
        }
        return Structures.inlindeDecodeValueInformation(context, data);
    }

    protected static void fillValueInformationCollection(BinaryContext context, IoBuffer data, int items, Collection<ValueInformation> values) throws Exception {
        int i = 0;
        while (i < items) {
            values.add(Structures.inlindeDecodeValueInformation(context, data));
            ++i;
        }
    }

    protected static <T extends Collection<ValueInformation>> T decodeValueInformationCollection(BinaryContext context, IoBuffer data, CollectionAllocator<ValueInformation, T> allactor, boolean allowNull) throws Exception {
        Integer len = context.beginReadStructureList(data, allowNull);
        if (len == null) {
            return null;
        }
        Collection result = allactor.allocate(len.intValue());
        Structures.fillValueInformationCollection(context, data, len, result);
        return (T)result;
    }

    public static List<ValueInformation> decodeListValueInformation(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        return (List)Structures.decodeValueInformationCollection(context, data, ALLOC_VALUEINFORMATION_LIST, allowNull);
    }

    public static Set<ValueInformation> decodeSetValueInformation(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        return (Set)Structures.decodeValueInformationCollection(context, data, ALLOC_VALUEINFORMATION_SET, allowNull);
    }

    protected static void inlineEncodeValueEntry(BinaryContext context, IoBuffer data, ValueEntry value) throws Exception {
        data.put((byte)2);
        context.encodeString(data, (byte)1, value.getValueType());
        context.encodeDoubleCollection(data, (byte)2, (Collection)value.getValues());
    }

    protected static ValueEntry inlindeDecodeValueEntry(BinaryContext _context, IoBuffer _data) throws Exception {
        int numberOfFields = _data.get();
        String valueType = null;
        List values = null;
        logger.trace("Decoding {} fields", (Object)((byte)numberOfFields));
        int i = 0;
        while (i < numberOfFields) {
            byte fieldNumber = _data.get();
            switch (fieldNumber) {
                case 1: {
                    valueType = _context.decodeString(_data);
                    break;
                }
                case 2: {
                    values = _context.decodeDoubleList(_data);
                    break;
                }
                default: {
                    logger.warn("Received unknown field number: {}", (Object)fieldNumber);
                }
            }
            ++i;
        }
        return new ValueEntry(valueType, values);
    }

    public static void encodeValueEntry(BinaryContext context, IoBuffer data, byte fieldNumber, ValueEntry value) throws Exception {
        context.beginWriteStructure(data, fieldNumber, value == null);
        if (value != null) {
            Structures.inlineEncodeValueEntry(context, data, value);
        }
    }

    public static void encodeCollectionValueEntry(BinaryContext context, IoBuffer data, byte fieldNumber, Collection<ValueEntry> values) throws Exception {
        context.beginWriteStructureList(data, fieldNumber, values);
        if (values == null) {
            return;
        }
        for (ValueEntry entry : values) {
            Structures.inlineEncodeValueEntry(context, data, entry);
        }
    }

    public static ValueEntry decodeValueEntry(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        boolean isNull = context.beginReadStructure(data, allowNull);
        if (isNull) {
            return null;
        }
        return Structures.inlindeDecodeValueEntry(context, data);
    }

    protected static void fillValueEntryCollection(BinaryContext context, IoBuffer data, int items, Collection<ValueEntry> values) throws Exception {
        int i = 0;
        while (i < items) {
            values.add(Structures.inlindeDecodeValueEntry(context, data));
            ++i;
        }
    }

    protected static <T extends Collection<ValueEntry>> T decodeValueEntryCollection(BinaryContext context, IoBuffer data, CollectionAllocator<ValueEntry, T> allactor, boolean allowNull) throws Exception {
        Integer len = context.beginReadStructureList(data, allowNull);
        if (len == null) {
            return null;
        }
        Collection result = allactor.allocate(len.intValue());
        Structures.fillValueEntryCollection(context, data, len, result);
        return (T)result;
    }

    public static List<ValueEntry> decodeListValueEntry(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        return (List)Structures.decodeValueEntryCollection(context, data, ALLOC_VALUEENTRY_LIST, allowNull);
    }

    public static Set<ValueEntry> decodeSetValueEntry(BinaryContext context, IoBuffer data, boolean allowNull) throws Exception {
        return (Set)Structures.decodeValueEntryCollection(context, data, ALLOC_VALUEENTRY_SET, allowNull);
    }
}

