/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.protocol.ngp.codec.impl;

import java.util.List;
import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.core.ngp.common.codec.osbp.BinaryContext;
import org.eclipse.scada.core.ngp.common.codec.osbp.BinaryMessageCodec;
import org.eclipse.scada.hd.data.ValueEntry;
import org.eclipse.scada.hd.data.ValueInformation;
import org.eclipse.scada.hd.protocol.ngp.codec.Structures;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateQueryData
implements BinaryMessageCodec {
    private static final Logger logger = LoggerFactory.getLogger(UpdateQueryData.class);
    public static final int MESSAGE_CODE = 12295;

    public int getMessageCode() {
        return 12295;
    }

    public Class<?> getMessageClass() {
        return org.eclipse.scada.hd.data.message.UpdateQueryData.class;
    }

    public org.eclipse.scada.hd.data.message.UpdateQueryData decodeMessage(BinaryContext _context, IoBuffer _data) throws Exception {
        int messageCode = _data.getInt();
        if (messageCode != 12295) {
            throw new IllegalStateException(String.format("Expected messageCode %s but found %s", 12295, messageCode));
        }
        int numberOfFields = _data.get();
        long queryId = 0L;
        int index = 0;
        List<ValueInformation> valueInformation = null;
        List<ValueEntry> values = null;
        logger.trace("Decoding {} fields", (Object)((byte)numberOfFields));
        int i = 0;
        while (i < numberOfFields) {
            byte fieldNumber = _data.get();
            switch (fieldNumber) {
                case 1: {
                    queryId = _context.decodePrimitiveLong(_data);
                    break;
                }
                case 2: {
                    index = _context.decodePrimitiveInt(_data);
                    break;
                }
                case 3: {
                    valueInformation = Structures.decodeListValueInformation(_context, _data, true);
                    break;
                }
                case 4: {
                    values = Structures.decodeListValueEntry(_context, _data, true);
                    break;
                }
                default: {
                    logger.warn("Received unknown field number: {}", (Object)fieldNumber);
                }
            }
            ++i;
        }
        return new org.eclipse.scada.hd.data.message.UpdateQueryData(queryId, index, valueInformation, values);
    }

    public IoBuffer encodeMessage(BinaryContext context, Object objectMessage) throws Exception {
        org.eclipse.scada.hd.data.message.UpdateQueryData value = (org.eclipse.scada.hd.data.message.UpdateQueryData)objectMessage;
        IoBuffer data = IoBuffer.allocate((int)64);
        data.setAutoExpand(true);
        data.putInt(12295);
        data.put((byte)4);
        context.encodePrimitiveLong(data, (byte)1, value.getQueryId());
        context.encodePrimitiveInt(data, (byte)2, value.getIndex());
        Structures.encodeCollectionValueInformation(context, data, (byte)3, value.getValueInformation());
        Structures.encodeCollectionValueEntry(context, data, (byte)4, value.getValues());
        data.flip();
        return data;
    }
}

