/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.subscription;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.scada.core.subscription.SubscriptionManager;
import org.eclipse.scada.core.subscription.SubscriptionManagerListener;
import org.eclipse.scada.core.subscription.SubscriptionValidator;

public class ListenableSubscriptionManager<T>
extends SubscriptionManager<T> {
    private final Executor executor;
    private final Set<SubscriptionManagerListener<T>> listeners = new HashSet<SubscriptionManagerListener<T>>();
    private final Set<T> cache = new HashSet<T>();

    public ListenableSubscriptionManager(Executor executor) {
        this.executor = executor;
    }

    public ListenableSubscriptionManager(Executor executor, SubscriptionValidator<T> validator) {
        super(validator);
        this.executor = executor;
    }

    @Override
    protected void topicSubscriptionAdded(final T topic) {
        super.topicSubscriptionAdded(topic);
        if (this.cache.add(topic)) {
            final ArrayList<SubscriptionManagerListener<T>> listeners = new ArrayList<SubscriptionManagerListener<T>>(this.listeners);
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ListenableSubscriptionManager.this.fireAdded(listeners, Collections.singleton(topic));
                }
            });
        }
    }

    @Override
    protected void topicSubscriptionRemoved(final T topic) {
        super.topicSubscriptionRemoved(topic);
        if (this.cache.remove(topic)) {
            final ArrayList<SubscriptionManagerListener<T>> listeners = new ArrayList<SubscriptionManagerListener<T>>(this.listeners);
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ListenableSubscriptionManager.this.fireRemoved(listeners, Collections.singleton(topic));
                }
            });
        }
    }

    public synchronized void addManagerListener(SubscriptionManagerListener<T> listener) {
        if (this.listeners.add(listener)) {
            final ArrayList<SubscriptionManagerListener<T>> listeners = new ArrayList<SubscriptionManagerListener<T>>(this.listeners);
            final HashSet<T> cache = new HashSet<T>(this.cache);
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ListenableSubscriptionManager.this.fireAdded(listeners, cache);
                }
            });
        }
    }

    public synchronized void removeManagerListener(SubscriptionManagerListener<T> listener) {
        this.listeners.remove(listener);
    }

    protected void fireAdded(List<SubscriptionManagerListener<T>> listeners, Set<T> topic) {
        for (SubscriptionManagerListener<T> listener : listeners) {
            try {
                listener.subscriptionsAdded(topic);
            }
            catch (Exception exception) {}
        }
    }

    protected void fireRemoved(List<SubscriptionManagerListener<T>> listeners, Set<T> topic) {
        for (SubscriptionManagerListener<T> listener : listeners) {
            try {
                listener.subscriptionsRemoved(topic);
            }
            catch (Exception exception) {}
        }
    }

    public synchronized Set<T> getAllSubscribedTopics() {
        return new HashSet<T>(this.cache);
    }

    public synchronized void dispose() {
        this.cache.clear();
        this.listeners.clear();
    }
}

