/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.chart;

import java.util.concurrent.TimeUnit;
import org.eclipse.scada.utils.beans.AbstractPropertyChange;

public class XAxis
extends AbstractPropertyChange {
    public static final String PROP_MIN = "min";
    public static final String PROP_MAX = "max";
    public static final String PROP_LABEL = "label";
    private long min;
    private long max;
    private String label;

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
        this.firePropertyChange(PROP_LABEL, this.label, this.label);
    }

    public long getMin() {
        return this.min;
    }

    public void setMin(long min) {
        this.min = min;
        this.firePropertyChange(PROP_MIN, this.min, this.min);
    }

    public long getMax() {
        return this.max;
    }

    public void setMax(long max) {
        this.max = max;
        this.firePropertyChange(PROP_MAX, this.max, this.max);
    }

    public void setMinMax(long min, long max) {
        if (min >= max) {
            return;
        }
        this.setMin(min);
        this.setMax(max);
    }

    public void zoom(double factor) {
        double diff = this.max - this.min;
        diff *= factor;
        if (factor > 1.0) {
            this.setMinMax((long)((double)this.min - diff), (long)((double)this.max + diff));
        } else {
            this.setMinMax((long)((double)this.min + diff), (long)((double)this.max - diff));
        }
    }

    public void transform(long offset, int clientWidth) {
        long diff = this.max - this.min;
        double factor = (double)diff / (double)clientWidth;
        long clientOffset = (long)((double)offset * factor);
        this.setMinMax(this.min + clientOffset, this.max + clientOffset);
    }

    public float translateToClient(int width, long time) {
        double diffX = this.max - this.min;
        double factorX = (double)width / diffX;
        return (float)(factorX * (double)(time - this.min));
    }

    public long translateToValue(int width, float position) {
        double pos = position / (float)width;
        long diffX = this.max - this.min;
        return (long)((double)diffX * pos) + this.min;
    }

    public void setByTimespan(long amount, TimeUnit timeUnit) {
        long millis = timeUnit.toMillis(amount);
        long pos = this.min + (this.max - this.min) / 2L;
        this.setMinMax(pos - millis / 2L, pos + millis / 2L);
    }

    public void shiftByTimespan(long duration, TimeUnit timeUnit) {
        long millis = timeUnit.toMillis(duration);
        this.setMinMax(this.min + millis, this.max + millis);
    }

    public void setNowCenter() {
        this.setCenter(System.currentTimeMillis());
    }

    public void setCenter(long center) {
        long diff = this.max - this.min;
        this.setMinMax(center - diff / 2L, center + diff / 2L);
    }

    public void setStartTimestamp(long milliseconds) {
        long diff = this.max - this.min;
        this.setMinMax(milliseconds, milliseconds + diff);
    }
}

