/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.ngp.common.mc.handshake;

import java.util.Map;
import org.eclipse.scada.protocol.ngp.common.ChainConfigurator;
import org.eclipse.scada.protocol.ngp.common.ProtocolConfiguration;
import org.eclipse.scada.protocol.ngp.common.mc.handshake.AbstractHandshake;
import org.eclipse.scada.protocol.ngp.common.mc.handshake.HandshakeContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamCompressionHandshake
extends AbstractHandshake {
    private static final String PROP_DISABLE_COMPRESSION = "org.eclipse.scada.protocol.ngp.common.mc.handshake.disableCompression";
    private static final Logger logger = LoggerFactory.getLogger(StreamCompressionHandshake.class);
    private final Integer maxStreamCompressionLevel;

    public StreamCompressionHandshake(Integer maxStreamCompressionLevel) {
        if (Boolean.getBoolean(PROP_DISABLE_COMPRESSION)) {
            logger.info("Stream compression disabled by system property (%s)", (Object)PROP_DISABLE_COMPRESSION);
            this.maxStreamCompressionLevel = null;
        } else {
            this.maxStreamCompressionLevel = maxStreamCompressionLevel != null ? Integer.valueOf(Math.min(maxStreamCompressionLevel, 9)) : null;
        }
    }

    @Override
    public void request(HandshakeContext handshakeContext, Map<String, String> helloProperties) {
        if (Boolean.getBoolean(PROP_DISABLE_COMPRESSION)) {
            logger.info("Stream compression disabled by system property (%s)", (Object)PROP_DISABLE_COMPRESSION);
            return;
        }
        ProtocolConfiguration protocolConfiguration = handshakeContext.getProtocolConfiguration();
        logger.debug("Stream compression in protocol configuration: {}", (Object)protocolConfiguration.getStreamCompressionLevel());
        if (protocolConfiguration.getStreamCompressionLevel() == -1 || protocolConfiguration.getStreamCompressionLevel() > 0) {
            String value = String.format("%s", protocolConfiguration.getStreamCompressionLevel());
            logger.info("Requesting stream compression level = {}", (Object)value);
            helloProperties.put("streamCompressionLevel", value);
        }
    }

    @Override
    public void handshake(HandshakeContext handshakeContext, Map<String, String> helloProperties, Map<String, String> acceptedProperties) throws Exception {
        Integer streamCompressionLevel = this.performHandshake(helloProperties, acceptedProperties);
        logger.info("Setting stream compression to: {}", (Object)streamCompressionLevel);
        if (streamCompressionLevel != null) {
            acceptedProperties.put("streamCompressionLevel", "" + streamCompressionLevel);
        }
    }

    protected Integer performHandshake(Map<String, String> helloProperties, Map<String, String> acceptedProperties) {
        Integer streamCompressionLevel = this.getInteger(helloProperties, "streamCompressionLevel", null);
        logger.debug("Stream compression level settings - ours: {}, theirs: {}", (Object)this.maxStreamCompressionLevel, (Object)streamCompressionLevel);
        if (streamCompressionLevel == null) {
            return null;
        }
        if (this.maxStreamCompressionLevel == null) {
            return null;
        }
        if (streamCompressionLevel < 0) {
            return this.maxStreamCompressionLevel;
        }
        if (this.maxStreamCompressionLevel < 0) {
            return streamCompressionLevel;
        }
        return Math.min(this.maxStreamCompressionLevel, streamCompressionLevel);
    }

    @Override
    public void apply(HandshakeContext handshakeContext, Map<String, String> acceptedProperties) throws Exception {
        Integer streamCompressionLevel = this.getInteger(acceptedProperties, "streamCompressionLevel", null);
        if (streamCompressionLevel != null) {
            new ChainConfigurator(handshakeContext.getSession()).startStreamCompression(streamCompressionLevel, !handshakeContext.isClientMode());
        }
    }

    @Override
    public void postApply(HandshakeContext context, Map<String, String> acceptedProperties) throws Exception {
    }

    @Override
    public void sessionStarted(HandshakeContext context, Map<String, String> acceptedProperties) throws Exception {
    }
}

