/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.client;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.ae.client.Connection;
import org.eclipse.scada.ae.client.EventListener;
import org.eclipse.scada.ae.client.internal.EventSyncController;
import org.eclipse.scada.core.client.ConnectionState;
import org.eclipse.scada.core.client.ConnectionStateListener;

public class EventManager
implements ConnectionStateListener {
    private final Connection connection;
    private boolean connected;
    private final Map<String, EventSyncController> eventListeners = new HashMap<String, EventSyncController>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventManager(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("connection is null");
        }
        this.connection = connection;
        EventManager eventManager = this;
        synchronized (eventManager) {
            this.connection.addConnectionStateListener(this);
            this.connected = this.connection.getState() == ConnectionState.BOUND;
        }
    }

    public void stateChange(org.eclipse.scada.core.client.Connection connection, ConnectionState state, Throwable error) {
        switch (state) {
            case BOUND: {
                if (this.connected) break;
                this.connected = true;
                break;
            }
            case CLOSED: {
                for (EventSyncController controller : this.eventListeners.values()) {
                    controller.dispose();
                }
                this.eventListeners.clear();
            }
            default: {
                if (!this.connected) break;
                this.connected = false;
            }
        }
    }

    public synchronized void addEventListener(String id, EventListener listener) {
        EventSyncController eventSyncController = this.eventListeners.get(id);
        if (eventSyncController == null) {
            eventSyncController = new EventSyncController(this.connection, id);
            this.eventListeners.put(id, eventSyncController);
        }
        eventSyncController.addListener(listener);
    }

    public synchronized void removeEventListener(String id, EventListener listener) {
        EventSyncController eventSyncController = this.eventListeners.get(id);
        if (eventSyncController == null) {
            return;
        }
        eventSyncController.removeListener(listener);
    }

    public boolean isConnected() {
        return this.connected;
    }
}

