/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.client.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.client.Connection;
import org.eclipse.scada.ae.client.EventListener;
import org.eclipse.scada.ae.client.internal.CollectionsBackPort;
import org.eclipse.scada.core.data.SubscriptionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventSyncController
implements EventListener {
    private static final Logger logger = LoggerFactory.getLogger(EventSyncController.class);
    private final List<EventListener> listeners = new CopyOnWriteArrayList<EventListener>();
    private final Connection connection;
    private final String id;
    private final Set<Event> cachedEvents = CollectionsBackPort.newSetFromMap(new ConcurrentHashMap());

    public EventSyncController(Connection connection, String id) {
        if (connection == null) {
            throw new IllegalArgumentException("connection is null");
        }
        this.connection = connection;
        this.id = id;
        this.connection.setEventListener(this.id, this);
    }

    public synchronized void addListener(EventListener listener) {
        this.listeners.add(listener);
        listener.dataChanged(new ArrayList<Event>(this.cachedEvents));
    }

    public synchronized boolean removeListener(EventListener listener) {
        this.listeners.remove(listener);
        return this.listeners.size() == 0;
    }

    @Override
    public void dataChanged(List<Event> addedEvents) {
        this.cachedEvents.removeAll(addedEvents);
        this.cachedEvents.addAll(addedEvents);
        for (EventListener listener : this.listeners) {
            listener.dataChanged(addedEvents);
        }
    }

    @Override
    public void statusChanged(SubscriptionState state) {
        this.fireStateChange(state);
        switch (state) {
            case CONNECTED: {
                for (EventListener listener : this.listeners) {
                    listener.dataChanged(new ArrayList<Event>(this.cachedEvents));
                }
                break;
            }
        }
    }

    private void fireStateChange(SubscriptionState state) {
        for (EventListener listener : this.listeners) {
            try {
                listener.statusChanged(state);
            }
            catch (Exception e) {
                logger.debug("Failed to notify subscription change", (Throwable)e);
            }
        }
    }

    public void dispose() {
        this.connection.setEventListener(this.id, null);
    }
}

