/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.protocol.ngp.codec.impl;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.ae.data.MonitorStatusInformation;
import org.eclipse.scada.ae.protocol.ngp.codec.Structures;
import org.eclipse.scada.core.ngp.common.codec.osbp.BinaryContext;
import org.eclipse.scada.core.ngp.common.codec.osbp.BinaryMessageCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorPoolDataUpdate
implements BinaryMessageCodec {
    private static final Logger logger = LoggerFactory.getLogger(MonitorPoolDataUpdate.class);
    public static final int MESSAGE_CODE = 8196;

    public int getMessageCode() {
        return 8196;
    }

    public Class<?> getMessageClass() {
        return org.eclipse.scada.ae.data.message.MonitorPoolDataUpdate.class;
    }

    public org.eclipse.scada.ae.data.message.MonitorPoolDataUpdate decodeMessage(BinaryContext _context, IoBuffer _data) throws Exception {
        int messageCode = _data.getInt();
        if (messageCode != 8196) {
            throw new IllegalStateException(String.format("Expected messageCode %s but found %s", 8196, messageCode));
        }
        int numberOfFields = _data.get();
        String monitorPoolId = null;
        List<MonitorStatusInformation> addedOrUpdated = null;
        Set removed = null;
        boolean full = false;
        logger.trace("Decoding {} fields", (Object)((byte)numberOfFields));
        int i = 0;
        while (i < numberOfFields) {
            byte fieldNumber = _data.get();
            switch (fieldNumber) {
                case 1: {
                    monitorPoolId = _context.decodeString(_data);
                    break;
                }
                case 2: {
                    addedOrUpdated = Structures.decodeListMonitorStatusInformation(_context, _data, true);
                    break;
                }
                case 3: {
                    removed = _context.decodeStringSet(_data);
                    break;
                }
                case 4: {
                    full = _context.decodePrimitiveBoolean(_data);
                    break;
                }
                default: {
                    logger.warn("Received unknown field number: {}", (Object)fieldNumber);
                }
            }
            ++i;
        }
        return new org.eclipse.scada.ae.data.message.MonitorPoolDataUpdate(monitorPoolId, addedOrUpdated, removed, full);
    }

    public IoBuffer encodeMessage(BinaryContext context, Object objectMessage) throws Exception {
        org.eclipse.scada.ae.data.message.MonitorPoolDataUpdate value = (org.eclipse.scada.ae.data.message.MonitorPoolDataUpdate)objectMessage;
        IoBuffer data = IoBuffer.allocate((int)64);
        data.setAutoExpand(true);
        data.putInt(8196);
        data.put((byte)4);
        context.encodeString(data, (byte)1, value.getMonitorPoolId());
        Structures.encodeCollectionMonitorStatusInformation(context, data, (byte)2, value.getAddedOrUpdated());
        context.encodeStringCollection(data, (byte)3, (Collection)value.getRemoved());
        context.encodePrimitiveBoolean(data, (byte)4, value.isFull());
        data.flip();
        return data;
    }
}

