/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.ui.connection.dnd;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.eclipse.scada.da.ui.connection.data.Item;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemTransfer
extends ByteArrayTransfer {
    private static ItemTransfer instance = new ItemTransfer();
    private static final String TYPE_NAME = "eclipse-scada-da-item-transfer-format-v2";
    private static final int TYPE_ID = ItemTransfer.registerType((String)"eclipse-scada-da-item-transfer-format-v2");
    private static final Logger logger = LoggerFactory.getLogger(ItemTransfer.class);

    static {
        logger.info("Registered type '{}' with id '{}'", (Object)TYPE_NAME, (Object)TYPE_ID);
    }

    public static ItemTransfer getInstance() {
        return instance;
    }

    private ItemTransfer() {
    }

    protected Item[] fromByteArray(byte[] bytes) {
        try {
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
            return (Item[])in.readObject();
        }
        catch (Exception e) {
            logger.warn("Failed to decode", (Throwable)e);
            return null;
        }
    }

    protected int[] getTypeIds() {
        return new int[]{TYPE_ID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    protected void javaToNative(Object object, TransferData transferData) {
        byte[] bytes = this.toByteArray((Item[])object);
        if (bytes != null) {
            super.javaToNative((Object)bytes, transferData);
        }
    }

    public Object nativeToJava(TransferData transferData) {
        byte[] bytes = (byte[])super.nativeToJava(transferData);
        if (bytes == null) {
            return null;
        }
        return this.fromByteArray(bytes);
    }

    protected byte[] toByteArray(Item[] items) {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        byte[] bytes = null;
        try {
            ObjectOutputStream out = new ObjectOutputStream(byteOut);
            out.writeObject(items);
            out.close();
            bytes = byteOut.toByteArray();
        }
        catch (IOException iOException) {}
        return bytes;
    }
}

