/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.ui.connection.views;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IDisposeListener;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.scada.da.client.FolderListener;
import org.eclipse.scada.da.core.Location;
import org.eclipse.scada.da.core.browser.Entry;
import org.eclipse.scada.da.ui.connection.internal.FolderEntryWrapper;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FolderObserver
implements FolderListener,
IObservableSet {
    private static final Logger logger = LoggerFactory.getLogger(FolderObserver.class);
    private final Map<String, FolderEntryWrapper> entries = new HashMap<String, FolderEntryWrapper>();
    private FolderEntryWrapper parent;
    protected WritableSet data = new WritableSet(SWTObservables.getRealm((Display)Display.getDefault()));

    protected void setFolderManager(FolderEntryWrapper parent) {
        if (this.parent != null) {
            this.parent.getFolderManager().removeFolderListener((FolderListener)this, this.parent.getLocation());
        }
        this.parent = parent;
        if (parent == null) {
            this.data.clear();
        } else {
            parent.getFolderManager().addFolderListener((FolderListener)this, parent.getLocation());
        }
    }

    public synchronized void dispose() {
        logger.debug("Disposed");
        if (this.parent != null) {
            this.parent.getFolderManager().removeFolderListener((FolderListener)this, this.parent.getLocation());
        }
        this.data.dispose();
    }

    public synchronized void folderChanged(final Collection<Entry> added, final Collection<String> removed, final boolean full) {
        if (this.data.isDisposed()) {
            logger.debug("Folder already disposed");
            return;
        }
        this.data.getRealm().asyncExec(new Runnable(){

            @Override
            public void run() {
                FolderObserver.this.handleChange(added, removed, full);
            }
        });
    }

    private synchronized void handleChange(Collection<Entry> added, Collection<String> removed, boolean full) {
        if (this.data.isDisposed()) {
            logger.debug("Folder already disposed");
            return;
        }
        this.data.setStale(true);
        try {
            if (full) {
                this.data.clear();
            }
            if (removed != null) {
                for (String name : removed) {
                    FolderEntryWrapper entry = this.entries.remove(name);
                    if (entry == null) continue;
                    this.data.remove((Object)entry);
                }
            }
            if (added != null) {
                for (Entry entry : added) {
                    FolderEntryWrapper newEntry = new FolderEntryWrapper(this.parent, entry, new Location(this.parent.getLocation(), entry.getName()));
                    FolderEntryWrapper oldEntry = this.entries.put(entry.getName(), newEntry);
                    if (oldEntry != null) {
                        this.data.remove((Object)oldEntry);
                    }
                    this.data.add((Object)newEntry);
                }
            }
        }
        finally {
            this.data.setStale(false);
        }
    }

    public void addChangeListener(IChangeListener listener) {
        this.data.addChangeListener(listener);
    }

    public void removeChangeListener(IChangeListener listener) {
        this.data.removeChangeListener(listener);
    }

    public void addStaleListener(IStaleListener listener) {
        this.data.addStaleListener(listener);
    }

    public void removeStaleListener(IStaleListener listener) {
        this.data.removeStaleListener(listener);
    }

    public void addDisposeListener(IDisposeListener listener) {
        this.data.addDisposeListener(listener);
    }

    public void removeDisposeListener(IDisposeListener listener) {
        this.data.removeDisposeListener(listener);
    }

    public void addSetChangeListener(ISetChangeListener listener) {
        this.data.addSetChangeListener(listener);
    }

    public void removeSetChangeListener(ISetChangeListener listener) {
        this.data.removeSetChangeListener(listener);
    }

    public boolean isDisposed() {
        return this.data.isDisposed();
    }

    public boolean contains(Object o) {
        return this.data.contains(o);
    }

    public boolean containsAll(Collection c) {
        return this.data.containsAll(c);
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public Iterator iterator() {
        return this.data.iterator();
    }

    public boolean add(Object o) {
        return this.data.add(o);
    }

    public boolean addAll(Collection c) {
        return this.data.addAll(c);
    }

    public int size() {
        return this.data.size();
    }

    public Object[] toArray() {
        return this.data.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.data.toArray(a);
    }

    public boolean remove(Object o) {
        return this.data.remove(o);
    }

    public String toString() {
        return this.data.toString();
    }

    public boolean removeAll(Collection c) {
        return this.data.removeAll(c);
    }

    public Realm getRealm() {
        return this.data.getRealm();
    }

    public boolean retainAll(Collection c) {
        return this.data.retainAll(c);
    }

    public boolean isStale() {
        return this.data.isStale();
    }

    public void setStale(boolean stale) {
        this.data.setStale(stale);
    }

    public void clear() {
        this.data.clear();
    }

    public Object getElementType() {
        return this.data.getElementType();
    }
}

