/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.client.net;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.mina.core.session.IoSession;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.client.PrivilegeListener;
import org.eclipse.scada.core.client.net.ConnectionBase;
import org.eclipse.scada.core.client.net.DisconnectReason;
import org.eclipse.scada.core.client.net.Messages;
import org.eclipse.scada.core.client.net.OperationTimedOutException;
import org.eclipse.scada.core.net.ConnectionHelper;
import org.eclipse.scada.core.net.MessageHelper;
import org.eclipse.scada.net.base.MessageListener;
import org.eclipse.scada.net.base.MessageStateListener;
import org.eclipse.scada.net.base.data.Message;
import org.eclipse.scada.net.base.data.Value;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SessionConnectionBase
extends ConnectionBase {
    private static final Logger logger = LoggerFactory.getLogger(SessionConnectionBase.class);
    public static final String SESSION_CLIENT_VERSION = "client-version";
    private final ConnectionInformation connectionInformation;
    protected ScheduledExecutorService executor;
    private final Set<PrivilegeListener> privilegeListeners = new LinkedHashSet<PrivilegeListener>();
    private volatile Set<String> currentPrivileges;

    public SessionConnectionBase(ConnectionInformation connectionInformation) {
        super(connectionInformation);
        this.connectionInformation = connectionInformation;
        this.executor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("ConnectionExecutor/" + this.getConnectionInformation().toMaskedString()));
        this.messenger.setHandler(65539, new MessageListener(){

            public void messageReceived(Message message) throws Exception {
                SessionConnectionBase.this.handlePrivChange(MessageHelper.getPrivileges((Message)message));
            }
        });
    }

    public abstract String getRequiredVersion();

    @Override
    public void dispose() {
        super.dispose();
        this.executor.shutdown();
    }

    @Override
    protected void onConnectionEstablished() {
        this.requestSession();
    }

    @Override
    protected void onConnectionClosed() {
        super.onConnectionClosed();
        this.handlePrivChange(Collections.<String>emptySet());
    }

    protected void requestSession() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.connectionInformation.getProperties());
        props.setProperty(SESSION_CLIENT_VERSION, this.getRequiredVersion());
        props.put(MessageHelper.PROP_USING_SESSION_START, "true");
        String username = (String)this.getConnectionInformation().getProperties().get("user");
        String password = (String)this.getConnectionInformation().getProperties().get("password");
        if (username != null && password != null) {
            props.put("user", username);
            props.put("password", password);
        } else if (username != null) {
            props.put("user", username);
        }
        this.messenger.sendMessage(MessageHelper.createSession((Properties)props), new MessageStateListener(){

            public void messageReply(Message message) {
                SessionConnectionBase.this.processSessionReply(message);
            }

            public void messageTimedOut() {
                SessionConnectionBase.this.disconnect(new OperationTimedOutException().fillInStackTrace());
            }
        }, (long)this.getMessageTimeout());
    }

    protected void processSessionReply(Message message) {
        logger.debug("Got session reply!");
        if (message.getValues().containsKey("error-info")) {
            String errorInfo = message.getValues().get("error-info").toString();
            this.disconnect(new DisconnectReason(String.format(Messages.getString("SessionConnectionBase.Error"), errorInfo)).fillInStackTrace());
        } else if (message.getCommandCode() != 3) {
            this.disconnect(new DisconnectReason(Messages.getString("SessionConnectionBase.InvalidReply")).fillInStackTrace());
        } else {
            Properties properties = new Properties();
            MessageHelper.getProperties((Properties)properties, (Value)message.getValues().get("properties"));
            logger.debug("Session properties: {}", (Object)properties);
            Properties transportProperties = new Properties();
            MessageHelper.getProperties((Properties)transportProperties, (Value)message.getValues().get("transport.properties"));
            logger.debug("Transport properties: {}", (Object)transportProperties);
            this.modifyFilterChain(this.session, transportProperties);
            this.messenger.sendMessage(new Message(65540));
            this.setBound(properties);
        }
    }

    protected void modifyFilterChain(IoSession session, Properties properties) {
        ConnectionHelper.injectCompression((IoSession)session, (String)properties.getProperty("transport.request.compression"));
    }

    protected synchronized void handlePrivChange(Set<String> privileges) {
        final Set<String> newPrivs = Collections.unmodifiableSet(privileges);
        this.currentPrivileges = newPrivs;
        logger.info("Privilege change: {}", privileges);
        for (final PrivilegeListener listener : this.privilegeListeners) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    listener.privilegesChanged(newPrivs);
                }
            });
        }
    }

    public synchronized void addPrivilegeListener(final PrivilegeListener listener) {
        final Set<String> newPrivs = this.currentPrivileges;
        if (this.privilegeListeners.add(listener)) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    listener.privilegesChanged(newPrivs);
                }
            });
        }
    }

    public synchronized void removePrivilegeListener(PrivilegeListener listener) {
        this.privilegeListeners.remove(listener);
    }

    public Set<String> getPrivileges() {
        return Collections.unmodifiableSet(this.currentPrivileges);
    }
}

