/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Alignment implements Enumerator
{
    LEFT(1, "LEFT", "LEFT"),
    CENTER(0, "CENTER", "CENTER"),
    RIGHT(2, "RIGHT", "RIGHT"),
    TOP(3, "TOP", "TOP"),
    BOTTOM(4, "BOTTOM", "BOTTOM");

    public static final int LEFT_VALUE = 1;
    public static final int CENTER_VALUE = 0;
    public static final int RIGHT_VALUE = 2;
    public static final int TOP_VALUE = 3;
    public static final int BOTTOM_VALUE = 4;
    private static final Alignment[] VALUES_ARRAY;
    public static final List<Alignment> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Alignment[]{LEFT, CENTER, RIGHT, TOP, BOTTOM};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Alignment get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Alignment result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Alignment getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Alignment result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Alignment get(int value) {
        switch (value) {
            case 1: {
                return LEFT;
            }
            case 0: {
                return CENTER;
            }
            case 2: {
                return RIGHT;
            }
            case 3: {
                return TOP;
            }
            case 4: {
                return BOTTOM;
            }
        }
        return null;
    }

    private Alignment(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

