/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.details.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TabStyle implements Enumerator
{
    DEFAULT(0, "DEFAULT", "DEFAULT"),
    NATIVE(1, "NATIVE", "NATIVE"),
    ENHANCED(2, "ENHANCED", "ENHANCED");

    public static final int DEFAULT_VALUE = 0;
    public static final int NATIVE_VALUE = 1;
    public static final int ENHANCED_VALUE = 2;
    private static final TabStyle[] VALUES_ARRAY;
    public static final List<TabStyle> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TabStyle[]{DEFAULT, NATIVE, ENHANCED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TabStyle get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TabStyle result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TabStyle getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TabStyle result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TabStyle get(int value) {
        switch (value) {
            case 0: {
                return DEFAULT;
            }
            case 1: {
                return NATIVE;
            }
            case 2: {
                return ENHANCED;
            }
        }
        return null;
    }

    private TabStyle(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

