/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.client;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.client.Connection;
import org.eclipse.scada.core.client.DriverFactory;
import org.eclipse.scada.core.client.DriverInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionFactory {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionFactory.class);
    protected static List<DriverFactory> registeredDrivers = new LinkedList<DriverFactory>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerDriverFactory(DriverFactory driverFactory) {
        List<DriverFactory> list = registeredDrivers;
        synchronized (list) {
            registeredDrivers.add(driverFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DriverInformation findDriver(ConnectionInformation connectionInformation) {
        if (!connectionInformation.isValid()) {
            throw new IllegalArgumentException("Connection information is not valid");
        }
        List<DriverFactory> list = registeredDrivers;
        synchronized (list) {
            for (DriverFactory factory : registeredDrivers) {
                DriverInformation di = factory.getDriverInformation(connectionInformation);
                if (di == null) continue;
                return di;
            }
        }
        return null;
    }

    public static Connection create(ConnectionInformation connectionInformation) {
        DriverInformation di = ConnectionFactory.findDriver(connectionInformation);
        if (di == null) {
            return null;
        }
        return di.create(connectionInformation);
    }

    public static Connection create(String className, ConnectionInformation connectionInformation) throws ClassNotFoundException {
        DriverInformation di;
        if (className != null) {
            logger.info("Pre-loading connection class: " + className);
            Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        }
        if ((di = ConnectionFactory.findDriver(connectionInformation)) == null) {
            logger.info("Driver not found: " + connectionInformation.getDriver());
            return null;
        }
        return di.create(connectionInformation);
    }
}

